/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.uml2.library;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.extensionpoints.uml2.Activator;
import org.eclipse.papyrus.extensionpoints.uml2.profile.RegisteredProfile;
import org.eclipse.papyrus.extensionpoints.uml2.standard.ExtensionLabelProvider;
import org.eclipse.papyrus.extensionpoints.uml2.utils.Util;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredProfileAsLibrarySelectionDialog
extends ElementListSelectionDialog {
    private EList importedProfiles;
    private List<String> importedProfilesNames;
    private RegisteredProfile[] regProfiles;
    private Package currentPackage;

    public RegisteredProfileAsLibrarySelectionDialog(Composite parent, Package umlPackage) {
        super(parent.getShell(), (ILabelProvider)new ExtensionLabelProvider());
        this.currentPackage = umlPackage;
        this.importedProfiles = umlPackage.getPackageImports();
        this.importedProfilesNames = this.getImportedProfileNames(this.importedProfiles);
        this.regProfiles = RegisteredProfile.getRegisteredProfiles();
        this.regProfiles = this.removeAlreadyImportedFromSelection();
        this.setTitle("Apply profiles from Papyrus repository :");
        this.setElements(this.regProfiles);
    }

    public boolean run() {
        this.open();
        return this.treatSelection();
    }

    private List<String> getImportedProfileNames(EList appliedProfiles) {
        ArrayList<String> Libraries = new ArrayList<String>();
        for (PackageImport currentImport : this.importedProfiles) {
            String currentName = currentImport.getImportedPackage().getName();
            Libraries.add(currentName);
        }
        return Libraries;
    }

    private RegisteredProfile[] removeAlreadyImportedFromSelection() {
        ArrayList<RegisteredProfile> profiles = new ArrayList<RegisteredProfile>();
        int i = 0;
        while (i < this.regProfiles.length) {
            String currentName = this.regProfiles[i].name;
            if (!this.importedProfilesNames.contains(currentName)) {
                profiles.add(this.regProfiles[i]);
            }
            ++i;
        }
        RegisteredProfile[] cleandList = profiles.toArray(new RegisteredProfile[profiles.size()]);
        return cleandList;
    }

    private boolean treatSelection() {
        Object[] selection = this.getResult();
        boolean hasChanged = false;
        if (selection == null) {
            return hasChanged;
        }
        int i = 0;
        while (i < selection.length) {
            RegisteredProfile currentProfile = (RegisteredProfile)selection[i];
            URI modelUri = currentProfile.uri;
            PackageImport pi = this.getModelLibraryImportFromURI(modelUri);
            if (pi != null) {
                this.currentPackage.getPackageImports().add((Object)pi);
            }
            ++i;
        }
        return hasChanged;
    }

    public PackageImport getModelLibraryImportFromURI(URI uri) {
        ResourceSet resourceSet = Util.getResourceSet((EObject)this.currentPackage);
        Resource modelResource = resourceSet.getResource(uri, true);
        if (modelResource.getContents().size() <= 0) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.extensionpoints.uml2", "No element found in model from URI " + uri.toString()));
            return null;
        }
        Element root = (Element)modelResource.getContents().get(0);
        if (root instanceof Package) {
            Package libToImport = (Package)modelResource.getContents().get(0);
            PackageImport modelLibImport = UMLFactory.eINSTANCE.createPackageImport();
            modelLibImport.setImportedPackage(libToImport);
            return modelLibImport;
        }
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.extensionpoints.uml2", "The selected uri (" + uri.toString() + ") does not contain any model library !"));
        return null;
    }
}

