/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.uml2.metamodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.extensionpoints.uml2.Activator;
import org.eclipse.papyrus.extensionpoints.uml2.metamodel.RegisteredMetamodel;
import org.eclipse.papyrus.extensionpoints.uml2.standard.ExtensionLabelProvider;
import org.eclipse.papyrus.extensionpoints.uml2.utils.Util;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredMetamodelSelectionDialog
extends ElementListSelectionDialog {
    private EList importedMetamodels;
    private List<String> importedMetamodelsNames;
    private RegisteredMetamodel[] regMetamodels;
    private Package currentModel;

    public RegisteredMetamodelSelectionDialog(Composite parent, Package umlModel) {
        super(parent.getShell(), (ILabelProvider)new ExtensionLabelProvider());
        this.currentModel = umlModel;
        this.importedMetamodels = umlModel.getPackageImports();
        this.importedMetamodelsNames = this.getImportedMetamodelsNames(this.importedMetamodels);
        this.regMetamodels = RegisteredMetamodel.getRegisteredMetamodels();
        this.regMetamodels = this.removeAlreadyImportedFromSelection();
        this.setTitle("Import Metamodel from Papyrus repository :");
        this.setElements(this.regMetamodels);
    }

    public void run() {
        this.open();
        this.treatSelection();
    }

    private List<String> getImportedMetamodelsNames(EList importedMetamodels) {
        ArrayList<String> Metamodels = new ArrayList<String>();
        for (PackageImport currentImport : importedMetamodels) {
            String currentName = currentImport.getImportedPackage().getName();
            Metamodels.add(currentName);
        }
        return Metamodels;
    }

    private RegisteredMetamodel[] removeAlreadyImportedFromSelection() {
        ArrayList<RegisteredMetamodel> Metamodels = new ArrayList<RegisteredMetamodel>();
        int i = 0;
        while (i < this.regMetamodels.length) {
            String currentName = this.regMetamodels[i].name;
            if (!this.importedMetamodelsNames.contains(currentName)) {
                Metamodels.add(this.regMetamodels[i]);
            }
            ++i;
        }
        RegisteredMetamodel[] cleanedList = Metamodels.toArray(new RegisteredMetamodel[Metamodels.size()]);
        return cleanedList;
    }

    private void treatSelection() {
        Object[] selection = this.getResult();
        if (selection == null) {
            return;
        }
        int i = 0;
        while (i < selection.length) {
            RegisteredMetamodel currentLibrary = (RegisteredMetamodel)selection[i];
            URI modelUri = currentLibrary.uri;
            this.addModelImportFromURI(this.currentModel, modelUri);
            ++i;
        }
    }

    protected boolean addModelImportFromURI(Package currentModel, URI modelUri) {
        Resource modelResource = Util.getResourceSet((EObject)currentModel).getResource(modelUri, true);
        if (modelResource.getContents().size() <= 0) {
            Activator.log("The selected uri (" + modelUri.toString() + ") does not contain any model library !");
            return false;
        }
        Element root = (Element)modelResource.getContents().get(0);
        if (root instanceof Package) {
            Package modelToImport = (Package)modelResource.getContents().get(0);
            PackageImport modelImport = UMLFactory.eINSTANCE.createPackageImport();
            modelImport.setImportedPackage(modelToImport);
            return currentModel.getPackageImports().add((Object)modelImport);
        }
        Activator.log("The selected uri (" + modelUri.toString() + ") does not contain any model library !");
        return false;
    }
}

