/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layouttool.subeditor.gmf;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.internal.commands.SendToBackCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.layouttool.LayoutToolAreaInterface;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class GMFLayoutAreaCreator
implements LayoutToolAreaInterface {
    private int margin = 10;
    private static EditPart myEditPartNode;
    private static Node node;
    private static EditPart editPartParent;
    private IDiagramWorkbenchPart idwp;
    private static TransactionalEditingDomain ted;
    private List<EditPart> childs;

    public void paintLayoutArea() {
        this.idwp = (IDiagramWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        editPartParent = this.idwp.getDiagramEditPart();
        this.childs = editPartParent.getChildren();
        if (myEditPartNode == null || !this.childs.contains(myEditPartNode)) {
            this.createLayoutArea();
        } else if (myEditPartNode != null && this.childs.contains(myEditPartNode)) {
            GMFLayoutAreaCreator.deleteLayoutArea();
            this.createLayoutArea();
        }
    }

    public static EditPart getArea() {
        return myEditPartNode;
    }

    public static void deleteLayoutArea() {
        if (myEditPartNode != null) {
            CommandStack cs = ((GraphicalEditPart)editPartParent).getViewer().getEditDomain().getCommandStack();
            CompositeCommand mycommand = new CompositeCommand("mcb");
            DeleteCommand dc = new DeleteCommand(ted, (View)myEditPartNode.getModel());
            mycommand.add((IUndoableOperation)dc);
            cs.execute((Command)new ICommandProxy((ICommand)mycommand));
            myEditPartNode = null;
            node = null;
        }
    }

    public static Rectangle getBounds() {
        if (myEditPartNode != null) {
            return ((GraphicalEditPart)myEditPartNode).getFigure().getBounds();
        }
        return null;
    }

    private TransactionalEditingDomain getTransactionalEditingDomain() {
        IDiagramWorkbenchPart workbenchPart;
        TransactionalEditingDomain ted = null;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof IDiagramWorkbenchPart && (ted = (TransactionalEditingDomain)(workbenchPart = (IDiagramWorkbenchPart)activeEditor).getAdapter(EditingDomain.class)) == null && workbenchPart instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor)workbenchPart;
            ted = editor.getEditingDomain();
        }
        return ted;
    }

    private void createLayoutArea() {
        CommandStack cs = ((GraphicalEditPart)editPartParent).getViewer().getEditDomain().getCommandStack();
        CompositeCommand command2 = new CompositeCommand("cb2");
        CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor(null, Node.class, "Note", -1, false, PreferencesHint.USE_DEFAULTS);
        ted = this.getTransactionalEditingDomain();
        CreateCommand cc = new CreateCommand(this.getTransactionalEditingDomain(), viewDescriptor, (View)editPartParent.getModel());
        command2.add((IUndoableOperation)cc);
        cs.execute((Command)new ICommandProxy((ICommand)command2));
        node = (Node)((CreateViewRequest.ViewDescriptor)cc.getCommandResult().getReturnValue()).getAdapter(Node.class);
        for (EditPart n : this.childs) {
            if (!n.getModel().equals(node)) continue;
            myEditPartNode = n;
        }
        ((GraphicalEditPart)myEditPartNode).getFigure().setBackgroundColor(null);
        ((GraphicalEditPart)myEditPartNode).getFigure().setOpaque(false);
        CompositeCommand command = new CompositeCommand("cb");
        SetBoundsCommand sbc = new SetBoundsCommand(this.getTransactionalEditingDomain(), "changebounds", (IAdaptable)new EObjectAdapter((EObject)((View)myEditPartNode.getModel())), this.calculateBoundsLayoutArea());
        command.add((IUndoableOperation)sbc);
        SendToBackCommand stbc = new SendToBackCommand(this.getTransactionalEditingDomain(), (View)myEditPartNode.getModel());
        command.add((IUndoableOperation)stbc);
        cs.execute((Command)new ICommandProxy((ICommand)command));
    }

    private Rectangle calculateBoundsLayoutArea() {
        int minX = ((Bounds)((Node)this.childs.get(0).getModel()).getLayoutConstraint()).getX();
        int maxX = ((Bounds)((Node)this.childs.get(0).getModel()).getLayoutConstraint()).getX();
        int minY = ((Bounds)((Node)this.childs.get(0).getModel()).getLayoutConstraint()).getY();
        int maxY = ((Bounds)((Node)this.childs.get(0).getModel()).getLayoutConstraint()).getY();
        for (EditPart e : this.childs) {
            if (e == this.childs.get(this.childs.size() - 1)) continue;
            minX = Math.min(minX, ((GraphicalEditPart)e).getFigure().getBounds().x - this.margin);
            maxX = Math.max(maxX, ((GraphicalEditPart)e).getFigure().getBounds().x + ((GraphicalEditPart)e).getFigure().getBounds().width + this.margin);
            minY = Math.min(minY, ((GraphicalEditPart)e).getFigure().getBounds().y - this.margin);
            maxY = Math.max(maxY, ((GraphicalEditPart)e).getFigure().getBounds().y + ((GraphicalEditPart)e).getFigure().getBounds().height + this.margin);
        }
        if (minX == 0 && minY == 0 && (maxX -= minX) == 0 && (maxY -= minY) == 0) {
            return new Rectangle(20, 20, 20, 20);
        }
        return new Rectangle(minX, minY, maxX, maxY);
    }
}

