/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layouttool.managealgorithms;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.layouttool.LayoutToolAlgorithms;
import org.eclipse.papyrus.layouttool.managealgorithms.AlgorithmFactory;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZestAlgortihms {
    public static Collection<LayoutToolAlgorithms> getRegisteredAlgorithmes() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.layouttool.algorithms");
        LinkedList<LayoutToolAlgorithms> algo = new LinkedList<LayoutToolAlgorithms>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                LayoutToolAlgorithms algorithm = new LayoutToolAlgorithms();
                AlgorithmFactory factory = (AlgorithmFactory)e.createExecutableExtension("class");
                algorithm.setAlgorithm(factory.createAlgorithm());
                if (e.getAttribute("name") != null) {
                    String name = e.getAttribute("name");
                    name = ZestAlgortihms.format(name);
                    algorithm.setName(name);
                }
                if (e.getAttribute("icon") != null) {
                    algorithm.setIcon(ZestAlgortihms.getIcon(e, e.getAttribute("icon")));
                }
                if (e.getAttribute("toolTipText") != null) {
                    algorithm.setToolTipText(e.getAttribute("toolTipText"));
                }
                if (e.getAttribute("path") != null) {
                    algorithm.setPath(e.getAttribute("path"));
                }
                algo.add(algorithm);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            if (!algo.isEmpty()) {
                Collections.sort(algo, new Comparator<LayoutToolAlgorithms>(){

                    @Override
                    public int compare(LayoutToolAlgorithms arg0, LayoutToolAlgorithms arg1) {
                        int length0 = 0;
                        if (arg0.getPath() != null) {
                            String[] pathSplit0 = arg0.getPath().split("\\.");
                            length0 = pathSplit0.length;
                        }
                        int length1 = 0;
                        if (arg1.getPath() != null) {
                            String[] pathSplit1 = arg1.getPath().split("\\.");
                            length1 = pathSplit1.length;
                        }
                        if (length1 == length0) {
                            String a = String.valueOf(arg0.getPath()) + arg0.getName();
                            String b = String.valueOf(arg1.getPath()) + arg1.getName();
                            if (a == null) {
                                // empty if block
                            }
                            if (b == null) {
                                // empty if block
                            }
                            return a.compareTo(b);
                        }
                        return length1 - length0;
                    }
                });
            }
            ++n2;
        }
        return algo;
    }

    private static String format(String name) {
        String[] split = name.split("\\s");
        StringBuffer result = new StringBuffer("");
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() > 0) {
                result.append(s.substring(0, 1).toUpperCase());
                result.append(s.substring(1, s.length()).toLowerCase());
                result.append(" ");
            }
            ++n2;
        }
        return result.toString();
    }

    private static Image getIcon(IConfigurationElement e, String attribute) {
        try {
            URL resource;
            Bundle bundle = Platform.getBundle((String)e.getContributor().getName());
            if (bundle != null && (resource = bundle.getResource(attribute)) != null) {
                return new Image((Device)Display.getDefault(), resource.openStream());
            }
        }
        catch (InvalidRegistryObjectException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return null;
    }
}

