/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.modelexplorer.SemanticFromModelExplorer;
import org.eclipse.papyrus.modelexplorer.widgets.Activator;
import org.eclipse.papyrus.modelexplorer.widgets.EMFObjectLabelProvider;
import org.eclipse.papyrus.modelexplorer.widgets.HierarchicViewerFilter;
import org.eclipse.papyrus.modelexplorer.widgets.HistoryContentProvider;
import org.eclipse.papyrus.modelexplorer.widgets.IMetaclassFilteredContentProvider;
import org.eclipse.papyrus.modelexplorer.widgets.MetaclassContentProvider;
import org.eclipse.papyrus.modelexplorer.widgets.MetaclassViewerFilter;
import org.eclipse.papyrus.modelexplorer.widgets.MetamodelContentFilter;
import org.eclipse.papyrus.modelexplorer.widgets.MetamodelContentProvider;
import org.eclipse.papyrus.modelexplorer.widgets.ModelContentProvider;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.ModelUtils;
import org.eclipse.papyrus.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.widgets.editors.ICommitListener;
import org.eclipse.papyrus.widgets.editors.StringEditor;
import org.eclipse.papyrus.widgets.providers.IDetailLabelProvider;
import org.eclipse.papyrus.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.widgets.providers.PatternViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicalModelExplorerBasedContentProvider
extends ModelContentProvider
implements IMetaclassFilteredContentProvider,
IHierarchicContentProvider,
IGraphicalContentProvider,
ISelectionChangedListener,
ICommitListener {
    private static final String DIALOG_SETTINGS = GraphicalModelExplorerBasedContentProvider.class.getName();
    protected ArrayList<Object> metaClassNotWantedList = new ArrayList();
    protected Object metaClassWanted = null;
    protected SemanticFromModelExplorer brige = new SemanticFromModelExplorer();
    protected String historyId;
    protected ViewerFilter currentMetaclassViewerFilter;
    protected ViewerFilter patternFilter;
    private static final String HISTORY_SETTINGS = "History";
    private static final String PREVIOUS_SELECTION = "PreviousSelection";
    protected List<EObject> selectionHistory;
    protected CLabel detailLabel;
    protected Object selectedObject;
    private static final int HISTORY_MAX_SIZE = 5;
    private String currentFilterPattern = "";

    public GraphicalModelExplorerBasedContentProvider(EObject semanticRoot, String historyId) {
        super(semanticRoot);
        this.historyId = historyId;
    }

    @Override
    public void setMetaClassNotWanted(List<Object> metaClassNotWanted) {
        this.metaClassNotWantedList.clear();
        this.metaClassNotWantedList.addAll(metaClassNotWanted);
    }

    @Override
    public void setMetaClassWanted(Object metaClassWanted) {
        this.metaClassWanted = metaClassWanted;
    }

    public Object getMetaClassWanted() {
        return this.metaClassWanted;
    }

    public boolean isValidValue(Object element) {
        if (this.metaClassWanted != null) {
            EObject semanticObject = null;
            if (element instanceof IAdaptable) {
                semanticObject = (EObject)this.brige.getSemanticElement(element);
            }
            if (element instanceof EObject) {
                semanticObject = (EObject)element;
            }
            if (element instanceof EReference || semanticObject instanceof EReference) {
                return false;
            }
            if (semanticObject != null) {
                if (this.metaClassWanted instanceof EClass && ((EClass)this.metaClassWanted).isSuperTypeOf(semanticObject.eClass())) {
                    if (this.metaClassNotWantedList.size() > 0) {
                        for (Object notWanted : this.metaClassNotWantedList) {
                            if (!(notWanted instanceof EClass) || !((EClass)notWanted).isSuperTypeOf(semanticObject.eClass())) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void createBefore(Composite parent) {
        this.createPatternFilter(parent);
    }

    protected void createPatternFilter(Composite parent) {
        StringEditor editor = new StringEditor(parent, 0);
        editor.setLabel("Filter:");
        editor.setToolTipText("Enter the name of the element you're looking for. You can use * as a wildcard");
        editor.setValidateOnDelay(true);
        this.patternFilter = new PatternViewerFilter();
        ((PatternViewerFilter)this.patternFilter).setPattern(this.currentFilterPattern);
        editor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                String filterPattern = (String)((StringEditor)editor).getValue();
                ((PatternViewerFilter)GraphicalModelExplorerBasedContentProvider.this.patternFilter).setPattern(filterPattern);
                GraphicalModelExplorerBasedContentProvider.this.viewer.refresh();
                if (!"".equals(filterPattern) && !GraphicalModelExplorerBasedContentProvider.this.currentFilterPattern.equals(filterPattern)) {
                    Object firstMatch = GraphicalModelExplorerBasedContentProvider.this.getFirstMatchingElement(null);
                    if (firstMatch != null) {
                        GraphicalModelExplorerBasedContentProvider.this.viewer.reveal(firstMatch);
                    }
                    GraphicalModelExplorerBasedContentProvider.this.currentFilterPattern = filterPattern;
                }
            }
        });
        LinkedList<ViewerFilter> filters = new LinkedList<ViewerFilter>(Arrays.asList(this.viewer.getFilters()));
        filters.add(this.patternFilter);
        this.viewer.setFilters(filters.toArray(new ViewerFilter[filters.size()]));
    }

    protected Object getFirstMatchingElement(Object parent) {
        if (parent == null) {
            Object[] objectArray = this.getElements(this.viewer.getInput());
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object parentElement = objectArray[n2];
                Object firstMatch = this.getFirstMatchingElement(parentElement);
                if (firstMatch != null) {
                    return firstMatch;
                }
                ++n2;
            }
            return null;
        }
        Object[] objectArray = this.viewer.getFilters();
        int n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            ViewerFilter filter = objectArray[n3];
            if (!filter.select((Viewer)this.viewer, this.getParent(parent), parent)) {
                return null;
            }
            ++n3;
        }
        if (this.isValidValue(parent)) {
            return parent;
        }
        objectArray = this.getChildren(parent);
        n = objectArray.length;
        n3 = 0;
        while (n3 < n) {
            ViewerFilter childElement = objectArray[n3];
            Object firstMatch = this.getFirstMatchingElement(childElement);
            if (firstMatch != null) {
                return firstMatch;
            }
            ++n3;
        }
        return null;
    }

    public void createAfter(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createHistory(parent);
        this.createDetailArea(parent);
    }

    protected void createHistory(Composite parent) {
        this.initSelectionHistory();
        Group historyGroup = new Group(parent, 0);
        historyGroup.setText("Recent selections");
        historyGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        historyGroup.setLayout((Layout)new GridLayout(1, true));
        Table historyTable = new Table((Composite)historyGroup, 2052);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 70;
        historyTable.setLayoutData((Object)data);
        final TableViewer historyViewer = new TableViewer(historyTable);
        historyViewer.setContentProvider((IContentProvider)new HistoryContentProvider());
        historyViewer.setLabelProvider(this.viewer.getLabelProvider());
        historyViewer.setInput(this.selectionHistory);
        historyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)historyViewer.getSelection();
                Object selectedObject = selection.getFirstElement();
                if (selectedObject instanceof EObject) {
                    EObject eObject = (EObject)selectedObject;
                    Object containerValue = GraphicalModelExplorerBasedContentProvider.this.getContainerValue(eObject);
                    if (containerValue == null) {
                        GraphicalModelExplorerBasedContentProvider.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    } else {
                        GraphicalModelExplorerBasedContentProvider.this.viewer.setSelection((ISelection)new StructuredSelection(containerValue), true);
                    }
                }
            }
        });
    }

    protected void initSelectionHistory() {
        String[] uriHistory;
        ServicesRegistry servicesRegistry = EditorUtils.getServiceRegistry();
        ModelSet modelSet = null;
        this.selectionHistory = new ArrayList<EObject>(6);
        try {
            modelSet = ModelUtils.getModelSetChecked((ServicesRegistry)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return;
        }
        IDialogSettings historySettings = this.getDialogSettings().getSection(HISTORY_SETTINGS);
        if (historySettings != null && (uriHistory = historySettings.getArray(PREVIOUS_SELECTION)) != null) {
            String[] stringArray = uriHistory;
            int n = uriHistory.length;
            int n2 = 0;
            while (n2 < n) {
                String uri = stringArray[n2];
                try {
                    EObject object = modelSet.getEObject(URI.createURI((String)uri), true);
                    if (object != null && !this.selectionHistory.contains(object)) {
                        this.selectionHistory.add(object);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    protected void createMetaclassFilter(Composite parent) {
        if (this.semanticRoot == null) {
            return;
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        ResourceSet resourceSet = this.semanticRoot.eResource().getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        Label metamodelLabel = new Label(container, 0);
        metamodelLabel.setText("Metamodel:");
        ComboViewer metamodelViewer = new ComboViewer(container);
        metamodelViewer.setContentProvider((IContentProvider)this.getMetamodelContentProvider());
        metamodelViewer.setLabelProvider((IBaseLabelProvider)new EMFObjectLabelProvider());
        metamodelViewer.setInput((Object)this.semanticRoot);
        metamodelViewer.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        Label metaclassLabel = new Label(container, 0);
        metaclassLabel.setText("Metaclass:");
        final ComboViewer metaclassViewer = new ComboViewer(container);
        IStructuredContentProvider metaclassProvider = this.getMetaclassContentProvider();
        metaclassViewer.setContentProvider((IContentProvider)metaclassProvider);
        metaclassViewer.setLabelProvider((IBaseLabelProvider)new EMFObjectLabelProvider());
        metaclassViewer.getCombo().setEnabled(false);
        metaclassViewer.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
        metamodelViewer.setFilters(new ViewerFilter[]{new MetamodelContentFilter(metaclassProvider)});
        metamodelViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                metaclassViewer.setInput(((IStructuredSelection)event.getSelection()).getFirstElement());
                metaclassViewer.getCombo().setEnabled(true);
            }
        });
        metaclassViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    Object selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    LinkedList<ViewerFilter> filters = new LinkedList<ViewerFilter>(Arrays.asList(GraphicalModelExplorerBasedContentProvider.this.viewer.getFilters()));
                    filters.remove(GraphicalModelExplorerBasedContentProvider.this.currentMetaclassViewerFilter);
                    GraphicalModelExplorerBasedContentProvider.this.currentMetaclassViewerFilter = GraphicalModelExplorerBasedContentProvider.this.getMetaclassViewerFilter(selectedObject);
                    filters.add(GraphicalModelExplorerBasedContentProvider.this.currentMetaclassViewerFilter);
                    GraphicalModelExplorerBasedContentProvider.this.viewer.setFilters(filters.toArray(new ViewerFilter[filters.size()]));
                    GraphicalModelExplorerBasedContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    protected void createDetailArea(Composite parent) {
        this.detailLabel = new CLabel(parent, 2048);
        this.detailLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.updateDetailLabel();
    }

    protected IStructuredContentProvider getMetamodelContentProvider() {
        return new MetamodelContentProvider();
    }

    protected IStructuredContentProvider getMetaclassContentProvider() {
        return new MetaclassContentProvider((EClass)this.metaClassWanted, (List<Object>)this.metaClassNotWantedList);
    }

    protected ILabelProvider getLabelProvider() {
        return new EMFObjectLabelProvider();
    }

    protected ViewerFilter getMetaclassViewerFilter(Object selectedMetaClass) {
        return new MetaclassViewerFilter(selectedMetaClass);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(this.getDialogSettingsIdentifier());
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(this.getDialogSettingsIdentifier());
        }
        return settings;
    }

    private String getDialogSettingsIdentifier() {
        return String.valueOf(DIALOG_SETTINGS) + "_" + this.historyId;
    }

    protected void storeDialog(IDialogSettings settings, EObject currentValue) {
        if (this.selectionHistory.contains(currentValue)) {
            this.selectionHistory.remove(currentValue);
        }
        this.selectionHistory.add(0, currentValue);
        while (this.selectionHistory.size() > 5) {
            this.selectionHistory.remove(5);
        }
        ArrayList<String> uriList = new ArrayList<String>();
        for (EObject object : this.selectionHistory) {
            URI uri = EcoreUtil.getURI((EObject)object);
            uriList.add(uri.toString());
        }
        IDialogSettings historySettings = settings.getSection(HISTORY_SETTINGS);
        if (historySettings == null) {
            historySettings = settings.addNewSection(HISTORY_SETTINGS);
        }
        historySettings.put(PREVIOUS_SELECTION, uriList.toArray(new String[uriList.size()]));
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (this.viewer != null && newInput != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setFilters(new ViewerFilter[]{new HierarchicViewerFilter(this)});
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
        this.selectedObject = this.getAdaptedValue(this.selectedObject);
        this.updateDetailLabel();
    }

    private void updateDetailLabel() {
        if (this.detailLabel == null || this.detailLabel.isDisposed()) {
            return;
        }
        if (this.selectedObject == null) {
            this.detailLabel.setText("");
            this.detailLabel.setImage(null);
        } else {
            ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
            String description = labelProvider instanceof IDetailLabelProvider ? ((IDetailLabelProvider)labelProvider).getDetail(this.selectedObject) : labelProvider.getText(this.selectedObject);
            this.detailLabel.setText(description);
            this.detailLabel.setImage(labelProvider.getImage(this.selectedObject));
        }
        this.detailLabel.getParent().getParent().layout();
    }

    public void commit(AbstractEditor editor) {
        if (this.selectedObject instanceof EObject) {
            this.storeDialog(this.getDialogSettings(), (EObject)this.selectedObject);
        }
    }

    public void dispose() {
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        super.dispose();
    }
}

