/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.BigListItem;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.modelexplorer.SemanticFromModelExplorer;
import org.eclipse.papyrus.widgets.providers.AbstractTreeFilter;
import org.eclipse.papyrus.widgets.providers.IHierarchicContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicViewerFilter
extends AbstractTreeFilter {
    protected IHierarchicContentProvider contentProvider;

    public HierarchicViewerFilter(IHierarchicContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public boolean hasOneVisibleChild(Viewer viewer, Object element, ITreeContentProvider contentProvider, Set<Object> visitedElements) {
        if (this.useCache && this.visibleChild.containsKey(element)) {
            return (Boolean)this.visibleChild.get(element);
        }
        boolean result = false;
        if (visitedElements.add(element)) {
            SemanticFromModelExplorer bridge = new SemanticFromModelExplorer();
            EObject semanticObject = null;
            if (element instanceof IAdaptable) {
                semanticObject = (EObject)bridge.getSemanticElement(element);
            }
            if (element instanceof EObject) {
                semanticObject = (EObject)element;
            }
            if (element instanceof BigListItem) {
                Object[] children;
                Object[] objectArray = children = contentProvider.getChildren(element);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.isVisible(viewer, element, child) || this.hasOneVisibleChild(viewer, child, contentProvider, visitedElements)) {
                        result = true;
                    }
                    ++n2;
                }
            } else if (semanticObject != null) {
                EReference eReference;
                if (semanticObject instanceof EReference && this.isValidReference(eReference = (EReference)semanticObject)) {
                    Object[] children = contentProvider.getChildren(element);
                    Object[] objectArray = children;
                    int n = children.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object child = objectArray[n3];
                        if (this.isVisible(viewer, element, child) || this.hasOneVisibleChild(viewer, child, contentProvider, visitedElements)) {
                            result = true;
                        }
                        ++n3;
                    }
                }
                if (!result) {
                    TreeIterator iter = semanticObject.eAllContents();
                    while (iter.hasNext()) {
                        EObject subEObject = (EObject)iter.next();
                        if (!this.isVisible(viewer, semanticObject, subEObject) && !this.hasOneVisibleChild(viewer, subEObject, contentProvider, visitedElements)) continue;
                        result = true;
                        break;
                    }
                    if (!result) {
                        block3: for (EReference eReference2 : this.getReferencesToBrowse(semanticObject)) {
                            Object values = semanticObject.eGet((EStructuralFeature)eReference2);
                            if (values instanceof EList) {
                                for (Object value : (EList)values) {
                                    if (!this.isVisible(viewer, semanticObject, value) && !this.hasOneVisibleChild(viewer, value, contentProvider, visitedElements)) continue;
                                    result = true;
                                    continue block3;
                                }
                                continue;
                            }
                            if (!this.isVisible(viewer, semanticObject, values) && !this.hasOneVisibleChild(viewer, values, contentProvider, visitedElements)) continue;
                            result = true;
                        }
                    }
                }
            }
        }
        if (this.useCache) {
            this.visibleChild.put(element, result);
        }
        return result;
    }

    protected Set<EReference> getReferencesToBrowse(EObject element) {
        return new HashSet<EReference>();
    }

    protected boolean isValidReference(EReference eReference) {
        return eReference.isContainment() || eReference instanceof FacetReference || this.getReferencesToBrowse(null).contains(eReference);
    }

    public boolean isVisible(Viewer viewer, Object parentElement, Object element) {
        return this.contentProvider.isValidValue(element);
    }
}

