/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizableModelContentProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.modelexplorer.Activator;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.ModelUtils;
import org.eclipse.papyrus.resource.uml.UmlModel;
import org.eclipse.papyrus.resource.uml.UmlUtils;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.sasheditor.contentprovider.di.DiSashModelMngr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoDiscoContentProvider
extends CustomizableModelContentProvider {
    protected ModelSet modelSet;
    protected IPageMngr pageMngr;

    public MoDiscoContentProvider() {
        super(Activator.getDefault().getCustomizationManager());
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] arrayObject = super.getChildren(parentElement);
        if (arrayObject != null) {
            int i = 0;
            while (i < arrayObject.length) {
                result.add(arrayObject[i]);
                ++i;
            }
        }
        return result.toArray();
    }

    private List<Diagram> findAllExistingDiagrams(EObject owner) {
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        for (Object page : this.pageMngr.allPages()) {
            Diagram diagram;
            if (!(page instanceof Diagram) || !owner.equals((diagram = (Diagram)page).getElement())) continue;
            diagrams.add(diagram);
        }
        return diagrams;
    }

    public EObject[] getRootElements(Object inputElement) {
        block3: {
            try {
                if (inputElement instanceof ServicesRegistry) break block3;
                return null;
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
                return new EObject[0];
            }
        }
        ServicesRegistry servicesRegistry = (ServicesRegistry)inputElement;
        this.modelSet = ModelUtils.getModelSetChecked((ServicesRegistry)servicesRegistry);
        this.pageMngr = ((DiSashModelMngr)servicesRegistry.getService(DiSashModelMngr.class)).getIPageMngr();
        return this.getRootElements(this.modelSet);
    }

    protected EObject[] getRootElements(ModelSet modelSet) {
        UmlModel umlModel = UmlUtils.getUmlModel((ModelSet)modelSet);
        if (umlModel == null) {
            return null;
        }
        EList contents = umlModel.getResource().getContents();
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject eObject : contents) {
            result.add(eObject);
        }
        return result.toArray(new EObject[result.size()]);
    }
}

