/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizableModelLabelProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.modelexplorer.Activator;
import org.eclipse.papyrus.modelexplorer.Messages;
import org.eclipse.papyrus.validation.ValidationTool;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class MoDiscoLabelProvider
extends CustomizableModelLabelProvider {
    private IPageIconsRegistry editorRegistry;
    private static final Point size16 = new Point(16, 16);
    private static final ImageRegistry registry = new ImageRegistry();

    public MoDiscoLabelProvider() {
        super(Activator.getDefault().getCustomizationManager());
    }

    public String getMarkerMessage(Object element) {
        ValidationTool vt = new ValidationTool(element);
        return vt.getMarkerMessages();
    }

    public Image getImage(Object element) {
        ValidationTool vt = new ValidationTool(element);
        vt.tryChildIfEmpty();
        int severity = vt.getSeverity();
        if (element instanceof Diagram) {
            return this.getDecoratedImage(this.getEditorRegistry().getEditorIcon(element), severity);
        }
        return this.getDecoratedImage(super.getImage(element), severity);
    }

    private Image getDecoratedImage(Image baseImage, int severity) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor overlay = null;
        switch (severity) {
            case 2: {
                overlay = sharedImages.getImageDescriptor("IMG_DEC_FIELD_ERROR");
                break;
            }
            case 1: {
                overlay = sharedImages.getImageDescriptor("IMG_DEC_FIELD_WARNING");
                break;
            }
            default: {
                return baseImage;
            }
        }
        String decoratedImageId = baseImage.toString().concat(String.valueOf(severity));
        if (registry.get(decoratedImageId) == null) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
            imageDescriptorArray[3] = overlay;
            DecorationOverlayIcon decoratedImage = new DecorationOverlayIcon(baseImage, imageDescriptorArray, size16){};
            registry.put(decoratedImageId, (ImageDescriptor)decoratedImage);
        }
        return registry.get(decoratedImageId);
    }

    public IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)EditorUtils.getServiceRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    public String getText(Object element) {
        String text = null;
        if (element instanceof Diagram) {
            Diagram diagram = (Diagram)element;
            text = diagram.getName();
        } else if (element instanceof IAdaptable) {
            EObject obj = (EObject)((IAdaptable)element).getAdapter(EObject.class);
            if (obj instanceof InternalEObject && obj.eIsProxy()) {
                InternalEObject internal = (InternalEObject)obj;
                text = NLS.bind((String)Messages.MoDiscoLabelProvider_ProxyLabel, (Object)obj.getClass().getSimpleName(), (Object)internal.eProxyURI().trimFragment());
            } else {
                text = super.getText(element);
            }
        } else {
            text = super.getText(element);
        }
        return text;
    }
}

