/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer;

import java.util.LinkedList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.core.Activator;
import org.eclipse.papyrus.core.ui.pagebookview.MultiViewPageBookView;
import org.eclipse.papyrus.modelexplorer.ModelExplorerPage;
import org.eclipse.papyrus.modelexplorer.ModelExplorerView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ModelExplorerPageBookView
extends MultiViewPageBookView
implements IGotoMarker,
ITabbedPropertySheetPageContributor {
    public static final String VIEW_ID = "org.eclipse.papyrus.modelexplorer.modelexplorer";

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        ModelExplorerPage page = new ModelExplorerPage();
        this.initPage(page, part);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class == adapter) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return "TreeOutlinePage";
    }

    public Object findElementForEObject(TreeViewer treeViewer, EObject eObjectToFind) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)treeViewer.getContentProvider();
        Object[] elements = contentProvider.getElements(treeViewer.getInput());
        LinkedList<Object> elementsToHandle = new LinkedList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            elementsToHandle.add(element);
            ++n2;
        }
        while (!elementsToHandle.isEmpty()) {
            Object[] children;
            Object e = elementsToHandle.removeFirst();
            EObject eObject = (EObject)Platform.getAdapterManager().getAdapter(e, EObject.class);
            if (eObject != null && eObject.equals(eObjectToFind)) {
                return e;
            }
            if (!contentProvider.hasChildren(e) || (children = contentProvider.getChildren(e)) == null) continue;
            Object[] objectArray2 = children;
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                Object child = objectArray2[n4];
                elementsToHandle.addLast(child);
                ++n4;
            }
        }
        return null;
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.isSubtypeOf("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                CommonViewer treeViewer;
                Object modelElementItem;
                ModelExplorerView modelExplorerView;
                EditingDomain domain;
                EObject eObject;
                URI uri = URI.createURI((String)uriAttribute);
                IViewPart viewPart = this.getActiveView();
                if (viewPart instanceof ModelExplorerView && (eObject = (domain = (modelExplorerView = (ModelExplorerView)viewPart).getEditingDomain()).getResourceSet().getEObject(uri, true)) != null && (modelElementItem = this.findElementForEObject((TreeViewer)(treeViewer = ((ModelExplorerView)viewPart).getCommonViewer()), eObject)) != null) {
                    TreePath treePath = new TreePath(new Object[]{modelElementItem});
                    EObject parent = eObject.eContainer();
                    if (parent != null) {
                        Object parentElement = this.findElementForEObject((TreeViewer)treeViewer, parent);
                        treeViewer.expandToLevel(parentElement, 1);
                    }
                    treeViewer.setSelection((ISelection)new TreeSelection(treePath), true);
                }
            }
        }
        catch (CoreException exception) {
            Activator.log.error((Throwable)exception);
        }
    }
}

