/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.lifecycleevents.IEditorInputChangedListener;
import org.eclipse.papyrus.core.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.ui.IRevealSemanticElement;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.core.utils.ServiceUtils;
import org.eclipse.papyrus.modelexplorer.Activator;
import org.eclipse.papyrus.modelexplorer.CustomCommonViewer;
import org.eclipse.papyrus.modelexplorer.MatchingItem;
import org.eclipse.papyrus.modelexplorer.listener.DoubleClickListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorDecoratingLabelProvider;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelExplorerView
extends CommonNavigator
implements IRevealSemanticElement,
IEditingDomainProvider {
    private IMultiDiagramEditor editorPart;
    private ISaveAndDirtyService saveAndDirtyService;
    private TransactionalEditingDomain editingDomain;
    private AtomicBoolean isRefreshing = new AtomicBoolean(false);
    protected IEditorInputChangedListener editorInputChangedListener = new IEditorInputChangedListener(){

        public void editorInputChanged(FileEditorInput fileEditorInput) {
            ModelExplorerView.this.setPartName(fileEditorInput.getName());
        }

        public void isDirtyChanged() {
            ModelExplorerView.this.firePropertyChange(257);
        }
    };
    UndoActionHandler undoHandler;
    RedoActionHandler redoHandler;
    private IPropertySheetPage propertySheetPage = null;
    private final ResourceSetListener resourceSetListener = new ResourceSetListenerImpl(){

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            super.resourceSetChanged(event);
            ModelExplorerView.this.handleResourceSetChanged(event);
        }
    };
    private Transaction lastTrans = null;

    public ModelExplorerView(IMultiDiagramEditor part) {
        this.editorPart = part;
        this.setLinkingEnabled(true);
        try {
            this.saveAndDirtyService = (ISaveAndDirtyService)this.editorPart.getServicesRegistry().getService(ISaveAndDirtyService.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private void handleSelectionChangedFromDiagramEditor(IWorkbenchPart part, ISelection selection) {
        if (this.isLinkingEnabled() && part instanceof IEditorPart && selection instanceof IStructuredSelection) {
            Iterator selectionIterator = ((IStructuredSelection)selection).iterator();
            ArrayList<Object> semanticElementList = new ArrayList<Object>();
            while (selectionIterator.hasNext()) {
                Object currentSelection = selectionIterator.next();
                if (currentSelection instanceof IAdaptable) {
                    Object semanticElement = ((IAdaptable)currentSelection).getAdapter(EObject.class);
                    if (semanticElement == null) continue;
                    semanticElementList.add(semanticElement);
                    continue;
                }
                if (!(currentSelection instanceof EObject)) continue;
                semanticElementList.add(currentSelection);
            }
            this.revealSemanticElement(semanticElementList);
        }
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        CustomCommonViewer viewer = new CustomCommonViewer(this.getViewSite().getId(), aParent, 770);
        NavigatorContentService contentService = new NavigatorContentService(this.getViewSite().getId());
        Set descriptors = contentService.findDescriptorsByTriggerPoint(this.getInitialInput(), false);
        for (Object descriptor : descriptors) {
            if (!(descriptor instanceof NavigatorContentDescriptor)) continue;
            try {
                ILabelProvider labelProvider = ((NavigatorContentDescriptor)descriptor).createLabelProvider();
                viewer.setLabelProvider((IBaseLabelProvider)new NavigatorDecoratingLabelProvider(labelProvider));
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            break;
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer, (int)2);
        return viewer;
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.getCommonViewer().setSorter(null);
        ((CustomCommonViewer)this.getCommonViewer()).getDropAdapter().setFeedbackEnabled(true);
        this.getCommonViewer().addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
        Tree tree = this.getCommonViewer().getTree();
        Activator.getDefault().getCustomizationManager().installCustomPainter(tree);
    }

    public Control getControl() {
        return this.getCommonViewer().getControl();
    }

    public void init(IViewSite site, IMemento aMemento) throws PartInitException {
        super.init(site, aMemento);
        this.activate();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IWorkbenchPage page = site.getPage();
        page.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                ModelExplorerView.this.handleSelectionChangedFromDiagramEditor(part, selection);
            }
        });
    }

    private void hookGlobalHistoryHandler(IViewSite site) {
        this.undoHandler = new UndoActionHandler((IWorkbenchPartSite)site, null);
        this.redoHandler = new RedoActionHandler((IWorkbenchPartSite)site, null);
        IActionBars actionBars = site.getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoHandler);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoHandler);
    }

    private void handleResourceSetChanged(ResourceSetChangeEvent event) {
        Transaction curTrans = event.getTransaction();
        if (this.lastTrans != null && this.lastTrans.equals(curTrans)) {
            return;
        }
        this.lastTrans = curTrans;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                ModelExplorerView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.isRefreshing.compareAndSet(false, true)) {
            if (!this.getCommonViewer().isBusy()) {
                this.getCommonViewer().refresh();
            }
            this.isRefreshing.set(false);
        }
    }

    protected Object getInitialInput() {
        if (this.editorPart != null) {
            return this.editorPart.getServicesRegistry();
        }
        return super.getInitialInput();
    }

    private void activate() {
        if (this.editorPart != null) {
            try {
                this.editingDomain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.editorPart.getServicesRegistry());
                if (this.getCommonViewer() != null) {
                    this.getCommonViewer().setInput((Object)this.editorPart.getServicesRegistry());
                }
                this.editingDomain.addResourceSetListener(this.resourceSetListener);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            this.saveAndDirtyService.addInputChangedListener(this.editorInputChangedListener);
        }
        if (this.getCommonViewer() != null) {
            this.refresh();
        }
    }

    private IUndoContext getUndoContext(IMultiDiagramEditor part) {
        return (IUndoContext)part.getAdapter(IUndoContext.class);
    }

    private void deactivate() {
        if (this.editorPart != null) {
            if (Activator.log.isDebugEnabled()) {
                Activator.log.debug("deactivate " + this.editorPart.getTitle());
            }
            this.saveAndDirtyService.removeInputChangedListener(this.editorInputChangedListener);
        }
        this.editorPart = null;
        if (this.editingDomain != null) {
            this.editingDomain.removeResourceSetListener(this.resourceSetListener);
        }
    }

    public void dispose() {
        this.deactivate();
        super.dispose();
    }

    private IPropertySheetPage getPropertySheetPage() {
        IMultiDiagramEditor multiDiagramEditor = EditorUtils.getMultiDiagramEditor();
        if (multiDiagramEditor != null) {
            if (this.propertySheetPage == null && multiDiagramEditor instanceof ITabbedPropertySheetPageContributor) {
                ITabbedPropertySheetPageContributor contributor = (ITabbedPropertySheetPageContributor)multiDiagramEditor;
                this.propertySheetPage = new TabbedPropertySheetPage(contributor);
            }
            return this.propertySheetPage;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class.equals((Object)adapter)) {
            return this.getPropertySheetPage();
        }
        if (IUndoContext.class.equals((Object)adapter) && this.editorPart != null) {
            return this.editorPart.getAdapter(IUndoContext.class);
        }
        if (ISaveablePart.class.equals((Object)adapter)) {
            return this.saveAndDirtyService;
        }
        return super.getAdapter(adapter);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void selectReveal(ISelection selection) {
        if (this.getCommonViewer() != null) {
            this.getCommonViewer().setSelection(selection, true);
        }
    }

    public void revealSemanticElement(List<?> elementList) {
        ArrayList<MatchingItem> matchingItemsToSelect = new ArrayList<MatchingItem>();
        Iterable list = Iterables.transform((Iterable)Iterables.filter(elementList, EObject.class), (Function)new Function<Object, EObject>(){

            public EObject apply(Object from) {
                return (EObject)from;
            }
        });
        for (EObject currentEObject : list) {
            matchingItemsToSelect.add(new MatchingItem(currentEObject));
            if (this.getCommonViewer().getContentProvider() == null) continue;
            ArrayList<EObject> parents = new ArrayList<EObject>();
            EObject tmp = currentEObject.eContainer();
            while (tmp != null) {
                parents.add(tmp);
                tmp = tmp.eContainer();
            }
            Iterable reverseParents = Iterables.reverse(parents);
            EObject previousParent = null;
            for (EObject parent : reverseParents) {
                if (parent.eContainingFeature() != null && previousParent != null) {
                    this.getCommonViewer().expandToLevel((Object)new MatchingItem(previousParent, parent.eContainmentFeature()), 1);
                }
                this.getCommonViewer().expandToLevel((Object)new MatchingItem(parent), 1);
                previousParent = parent;
            }
            this.getCommonViewer().expandToLevel((Object)new MatchingItem(currentEObject.eContainer(), currentEObject.eContainmentFeature()), 1);
        }
        this.selectReveal((ISelection)new StructuredSelection(matchingItemsToSelect));
    }
}

