/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorUtils {
    public static IViewPart findViewPart(String viewID) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return null;
        }
        IViewReference reference = page.findViewReference(viewID);
        if (reference == null) {
            return null;
        }
        IWorkbenchPart part = reference.getPart(false);
        if (part instanceof IViewPart) {
            return (IViewPart)part;
        }
        return null;
    }

    public static EObject resolveSemanticObject(Object object) {
        IAdaptable adaptable;
        if (object instanceof EObject) {
            return (EObject)object;
        }
        if (object instanceof IAdaptable && (adaptable = (IAdaptable)object).getAdapter(EObject.class) != null) {
            return (EObject)adaptable.getAdapter(EObject.class);
        }
        return null;
    }

    public static ISelection unwrapSelection(ISelection selection) {
        if (selection instanceof StructuredSelection && !selection.isEmpty()) {
            ArrayList<EObject> selectionList = new ArrayList<EObject>();
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            for (Object next : structuredSelection) {
                EObject eObject;
                EObject element;
                if (next instanceof EditPart) {
                    Object model = ((EditPart)next).getModel();
                    EObject element2 = null;
                    if (model instanceof View) {
                        element2 = ((View)model).getElement();
                    } else if (model instanceof EObject) {
                        element2 = (EObject)model;
                    }
                    if (element2 != null) {
                        selectionList.add(element2);
                    }
                } else if (next instanceof View && (element = ((View)next).getElement()) != null) {
                    selectionList.add(element);
                }
                if ((eObject = NavigatorUtils.resolveSemanticObject(next)) == null) continue;
                selectionList.add(eObject);
            }
            return new StructuredSelection(selectionList);
        }
        return selection;
    }

    public static List<EditPart> getEditPartsFromSelection(ISelection selection, IDiagramGraphicalViewer viewer) {
        if (selection instanceof StructuredSelection && !selection.isEmpty()) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            ArrayList<View> views = new ArrayList<View>();
            for (Object o : structuredSelection.toList()) {
                if (!(o instanceof EObject)) continue;
                List<Object> referencerViews = NavigatorUtils.getEObjectViews((EObject)o);
                for (Object ro : referencerViews) {
                    if (!(ro instanceof View)) continue;
                    views.add((View)ro);
                }
            }
            if (!views.isEmpty()) {
                ArrayList<EditPart> editParts = new ArrayList<EditPart>();
                for (View view : views) {
                    Object ep = viewer.getEditPartRegistry().get(view);
                    if (!(ep instanceof EditPart)) continue;
                    editParts.add((EditPart)ep);
                }
                if (!editParts.isEmpty()) {
                    return editParts;
                }
            }
        }
        return Collections.emptyList();
    }

    public static List<Object> getEObjectViews(EObject element) {
        ArrayList<Object> views = new ArrayList<Object>();
        if (element != null) {
            EReference[] features = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
            Collection referencers = EMFCoreUtil.getReferencers((EObject)element, (EReference[])features);
            views.addAll(referencers);
        }
        return views;
    }

    public static void openDiagram(Diagram diagram) {
        IPageMngr pageManager = EditorUtils.getIPageMngr();
        if (pageManager != null) {
            pageManager.openPage((Object)diagram);
        }
    }

    public static void openViewPart(String viewPartID) {
        if (viewPartID == null) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewPartID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public static void openPropertySheetsView() {
        NavigatorUtils.openViewPart("org.eclipse.ui.views.PropertySheet");
    }

    public static <T> T getElement(Object o, Class<T> theClass) {
        Object result = null;
        if (o instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)o;
            result = adaptable.getAdapter(theClass);
        }
        if (result == null) {
            result = Platform.getAdapterManager().getAdapter(o, theClass);
        }
        if (result == null && theClass.isInstance(o)) {
            result = o;
        }
        return (T)result;
    }

    public static boolean find(EObject toFind, Predicate<EStructuralFeature.Setting> predicate) {
        if (toFind == null || toFind.eResource() == null || toFind.eResource().getResourceSet() == null) {
            return false;
        }
        ResourceSet resourceSet = toFind.eResource().getResourceSet();
        ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSet);
        if (adapter == null) {
            adapter = new ECrossReferenceAdapter();
            resourceSet.eAdapters().add((Object)adapter);
        }
        Collection settings = adapter.getInverseReferences(toFind, false);
        return Iterables.filter((Iterable)settings, predicate).iterator().hasNext();
    }

    public static <T> Collection<T> findFilterAndApply(EObject toFind, Predicate<EStructuralFeature.Setting> predicate, Function<EStructuralFeature.Setting, T> function) {
        if (toFind == null || toFind.eResource() == null || toFind.eResource().getResourceSet() == null) {
            return Collections.emptyList();
        }
        ResourceSet resourceSet = toFind.eResource().getResourceSet();
        ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSet);
        if (adapter == null) {
            adapter = new ECrossReferenceAdapter();
            resourceSet.eAdapters().add((Object)adapter);
        }
        Collection settings = adapter.getInverseReferences(toFind, false);
        return Lists.newLinkedList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)settings, predicate), function));
    }
}

