/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.actionprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.papyrus.modelexplorer.actionprovider.AbstractCommonActionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSubmenuActionProvider
extends AbstractCommonActionProvider {
    protected Map<String, Collection<IAction>> extractSubmenuActions(Collection<IAction> createActions, String token) {
        LinkedHashMap<String, Collection<IAction>> createSubmenuActions = new LinkedHashMap<String, Collection<IAction>>();
        if (createActions != null) {
            Iterator<IAction> actions = createActions.iterator();
            while (actions.hasNext()) {
                IAction action = actions.next();
                StringTokenizer st = new StringTokenizer(action.getText(), token);
                if (st.countTokens() != 2) continue;
                String text = st.nextToken().trim();
                ArrayList<IAction> submenuActions = (ArrayList<IAction>)createSubmenuActions.get(text);
                if (submenuActions == null) {
                    submenuActions = new ArrayList<IAction>();
                    createSubmenuActions.put(text, submenuActions);
                }
                action.setText(st.nextToken().trim());
                submenuActions.add(action);
                actions.remove();
            }
        }
        return createSubmenuActions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void populateManager(IContributionManager manager, Map<String, Collection<IAction>> submenuActions, String contributionID) {
        if (submenuActions != null) {
            for (Map.Entry<String, Collection<IAction>> entry : submenuActions.entrySet()) {
                MenuManager submenuManager = new MenuManager(entry.getKey());
                if (contributionID != null) {
                    manager.insertBefore(contributionID, (IContributionItem)submenuManager);
                } else {
                    manager.add((IContributionItem)submenuManager);
                }
                this.populateManager((IContributionManager)submenuManager, entry.getValue(), null);
            }
        }
    }
}

