/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.actionprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.modelexplorer.actionprovider.AbstractSubmenuActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateChildActionProvider
extends AbstractSubmenuActionProvider {
    protected Collection<IAction> createChildActions;
    protected Map<String, Collection<IAction>> createChildSubmenuActions;
    protected IMenuManager createChildMenuManager;

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        ISelection selection = this.getContext().getSelection();
        Collection newChildDescriptors = null;
        EObject selectedElement = null;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            selectedElement = this.resolveSemanticObject(((IStructuredSelection)selection).getFirstElement());
            TransactionalEditingDomain domain = EditorUtils.getTransactionalEditingDomain();
            if (domain == null) {
                return;
            }
            newChildDescriptors = domain.getNewChildDescriptors((Object)selectedElement, null);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createChildSubmenuActions = this.extractSubmenuActions(this.createChildActions, "|");
        MenuManager submenuManager = new MenuManager("New Child");
        this.populateManager((IContributionManager)submenuManager, this.createChildSubmenuActions, null);
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menu.add((IContributionItem)submenuManager);
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        List createChildActions = (List)this.generateCreateChildActionsGen(descriptors, selection);
        Collections.sort(createChildActions, new Comparator<IAction>(){

            @Override
            public int compare(IAction a1, IAction a2) {
                return a1.getText().compareTo(a2.getText());
            }
        });
        return createChildActions;
    }

    protected Collection<IAction> generateCreateChildActionsGen(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                if (!(descriptor instanceof CommandParameter)) continue;
                actions.add((IAction)new CreateChildAction((EditingDomain)EditorUtils.getTransactionalEditingDomain(), selection, descriptor));
            }
        }
        return actions;
    }
}

