/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.actionprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.modelexplorer.actionprovider.AbstractSubmenuActionProvider;
import org.eclipse.papyrus.modelexplorer.actions.GenericTransformAction;
import org.eclipse.papyrus.modelexplorer.actions.GenericTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTransformActionProvider
extends AbstractSubmenuActionProvider {
    private static final String TRANSFORM_INTO_LABEL = "Transform into";
    private Map<String, AdapterFactory> factories = new HashMap<String, AdapterFactory>();
    private Set<EClassifier> eClassifiers = new HashSet<EClassifier>();

    public void fillContextMenu(IMenuManager menu) {
        EObject selectedElement;
        super.fillContextMenu(menu);
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (selectedElement = this.resolveSemanticObject(((IStructuredSelection)selection).getFirstElement())) != null && selectedElement instanceof EObject) {
            this.fillEClassifiers(selectedElement);
        }
        Collection<IAction> genericTransformActions = this.generateTransformActions(selection);
        MenuManager submenuManager = new MenuManager(TRANSFORM_INTO_LABEL);
        this.populateManager((IContributionManager)submenuManager, genericTransformActions, null);
        menu.add((IContributionItem)submenuManager);
    }

    private void fillEClassifiers(EObject selectionEObject) {
        Resource r = selectionEObject.eResource();
        URI uri = r.getURI();
        String extension = uri.fileExtension();
        for (Object p : EPackage.Registry.INSTANCE.values()) {
            EPackage pack;
            if (!(p instanceof EPackage) || (pack = (EPackage)p).getNsPrefix() == null || !extension.toLowerCase().equals(pack.getNsPrefix().toLowerCase())) continue;
            this.addClassifiers(pack, this.eClassifiers);
            this.factories.put(pack.getNsURI(), GenericTransformer.getFactory(pack.getNsURI()));
            List packages = ConverterUtil.computeRequiredPackages((EPackage)pack);
            for (EPackage pTmp : packages) {
                this.addClassifiers(pTmp, this.eClassifiers);
                this.factories.put(pTmp.getNsURI(), GenericTransformer.getFactory(pTmp.getNsURI()));
            }
        }
    }

    private void addClassifiers(EPackage pack, Set<EClassifier> result) {
        for (EClassifier c : pack.getEClassifiers()) {
            result.add(c);
        }
    }

    protected Collection<IAction> generateTransformActions(ISelection selection) {
        List transformActions = (List)this.generateTransformActionsCore(selection);
        Collections.sort(transformActions, new Comparator<IAction>(){

            @Override
            public int compare(IAction a1, IAction a2) {
                return a1.getText().compareTo(a2.getText());
            }
        });
        return transformActions;
    }

    protected Collection<IAction> generateTransformActionsCore(ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (this.eClassifiers != null) {
            for (EClassifier descriptor : this.eClassifiers) {
                Object selected = ((IStructuredSelection)selection).getFirstElement();
                if (!(selected instanceof EObject)) continue;
                EObject selectedElement = (EObject)selected;
                if (!(descriptor instanceof EClass) || selectedElement.eContainingFeature() == null) continue;
                EClass eclass = (EClass)descriptor;
                EStructuralFeature containingFeature = selectedElement.eContainingFeature();
                EClass containgType = (EClass)containingFeature.getEType();
                if (!GenericTransformer.getAllSuperTypes(eclass).contains(containgType) && !EcoreUtil.equals((EObject)eclass, (EObject)containgType) || eclass.equals(selectedElement.eClass()) || eclass.isAbstract() || !(selection instanceof IStructuredSelection) || ((IStructuredSelection)selection).size() != 1) continue;
                AdapterFactory adapterFactory = this.factories.get(eclass.getEPackage().getNsURI());
                GenericTransformAction transformAction = new GenericTransformAction(eclass, adapterFactory, selectedElement);
                actions.add((IAction)transformAction);
                if (adapterFactory == null) continue;
                EObject tmpEobject = eclass.getEPackage().getEFactoryInstance().create(eclass);
                IItemLabelProvider provider = (IItemLabelProvider)adapterFactory.adapt((Notifier)tmpEobject, IItemLabelProvider.class);
                transformAction.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(provider.getImage((Object)tmpEobject)));
            }
        }
        return actions;
    }
}

