/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.papyrus.core.extension.NotFoundException;
import org.eclipse.papyrus.core.extension.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.core.extension.commands.CreationCommandRegistry;
import org.eclipse.papyrus.core.extension.commands.ICreationCommand;
import org.eclipse.papyrus.core.extension.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.modelexplorer.Activator;

public class CreateDiagramAction
extends Action {
    private final EObject container;
    private final CreationCommandDescriptor commandDescriptor;

    public CreateDiagramAction(EObject eObject, CreationCommandDescriptor commandDescriptor) {
        this.container = eObject;
        this.commandDescriptor = commandDescriptor;
        this.setText(commandDescriptor.getLabel());
        this.setImageDescriptor(commandDescriptor.getIcon());
    }

    public boolean isEnabled() {
        return this.container != null;
    }

    public void run() {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug("Start - CreateDiagramAction#run");
        }
        try {
            ICreationCommand creationCommand = CreateDiagramAction.getCreationCommandRegistry().getCommand(this.commandDescriptor.getCommandId());
            creationCommand.createDiagram(EditorUtils.getDiResourceSet(), this.container, null);
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug("End - CreateDiagramAction#run");
        }
    }

    private static ICreationCommandRegistry getCreationCommandRegistry() {
        return CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.core");
    }
}

