/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.navigator.CommonNavigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorSearchDialog
extends TrayDialog {
    protected ITreeContentProvider contentProvider = null;
    protected ILabelProvider labelProvider = null;
    protected Object root = null;
    protected ISelectionProvider viewer = null;
    protected List<Object> matchedObjects = Collections.emptyList();
    protected int currentIndex = 0;
    protected Label matchesLabel;
    protected Text searchText;
    protected Button backButton;
    protected Button nextButton;
    protected Button caseButton;
    protected Button launchButton;

    public NavigatorSearchDialog(Shell shell, CommonNavigator modelNavigator) {
        super(shell);
        this.setShellStyle(2144);
        IContentProvider cprovider = modelNavigator.getCommonViewer().getContentProvider();
        if (cprovider instanceof ITreeContentProvider) {
            this.contentProvider = (ITreeContentProvider)cprovider;
        }
        this.root = modelNavigator.getCommonViewer().getInput();
        this.viewer = modelNavigator.getCommonViewer();
        this.labelProvider = (ILabelProvider)modelNavigator.getCommonViewer().getLabelProvider();
    }

    public NavigatorSearchDialog(Shell shell, TreeViewer viewer) {
        super(shell);
        this.setShellStyle(2144);
        this.viewer = viewer;
        try {
            this.labelProvider = (ILabelProvider)viewer.getLabelProvider();
            this.contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.root = viewer.getInput();
    }

    public NavigatorSearchDialog(Shell shell, Viewer viewer, ITreeContentProvider contentProvider, ILabelProvider labelProvider, Object root) {
        super(shell);
        this.setShellStyle(2144);
        this.viewer = viewer;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.root = root;
    }

    protected void fireSetSelection(ISelection selection, boolean reveal) {
        this.viewer.setSelection(selection);
    }

    protected Control createDialogArea(Composite parent) {
        Composite background = new Composite(parent, 0);
        GridData bgData = new GridData(1808);
        bgData.minimumWidth = 300;
        background.setLayoutData((Object)bgData);
        GridLayout bgLayout = new GridLayout();
        bgLayout.numColumns = 2;
        background.setLayout((Layout)bgLayout);
        this.createSearchTextComposite(background);
        return background;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.launchButton = this.createButton(parent, 10, "Launch search", true);
        this.backButton = this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
        this.nextButton = this.createButton(parent, 15, IDialogConstants.NEXT_LABEL, false);
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.launchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NavigatorSearchDialog.this.updateMatches();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.nextButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NavigatorSearchDialog.this.currentIndex = NavigatorSearchDialog.this.currentIndex >= NavigatorSearchDialog.this.matchedObjects.size() - 1 ? 0 : ++NavigatorSearchDialog.this.currentIndex;
                NavigatorSearchDialog.this.fireSetSelection((ISelection)new StructuredSelection(NavigatorSearchDialog.this.matchedObjects.get(NavigatorSearchDialog.this.currentIndex)), true);
            }
        });
        this.backButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NavigatorSearchDialog.this.currentIndex = NavigatorSearchDialog.this.currentIndex <= 0 ? NavigatorSearchDialog.this.matchedObjects.size() - 1 : --NavigatorSearchDialog.this.currentIndex;
                NavigatorSearchDialog.this.fireSetSelection((ISelection)new StructuredSelection(NavigatorSearchDialog.this.matchedObjects.get(NavigatorSearchDialog.this.currentIndex)), true);
            }
        });
    }

    protected void createSearchTextComposite(Composite background) {
        Label searchLabel = new Label(background, 0);
        searchLabel.setText("Search:");
        searchLabel.setLayoutData((Object)new GridData(128));
        this.searchText = new Text(background, 128);
        this.searchText.setFocus();
        this.searchText.setLayoutData((Object)new GridData(768));
        this.searchText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                NavigatorSearchDialog.this.clearMatches();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.caseButton = new Button(background, 32);
        this.caseButton.setText("Case sensitive?");
        GridData caseButtonData = new GridData(32);
        caseButtonData.horizontalSpan = 2;
        this.caseButton.setSelection(false);
        this.caseButton.setLayoutData((Object)caseButtonData);
        this.caseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NavigatorSearchDialog.this.clearMatches();
            }
        });
        Label resultsLabel = new Label(background, 0);
        resultsLabel.setText("Results:");
        resultsLabel.setLayoutData((Object)new GridData(128));
        this.matchesLabel = new Label(background, 0);
        this.matchesLabel.setText("");
        this.matchesLabel.setLayoutData((Object)new GridData(800));
    }

    protected void clearMatches() {
        this.matchedObjects = Collections.emptyList();
        this.currentIndex = 0;
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.matchesLabel.setText("");
    }

    protected void updateMatches() {
        if (this.contentProvider == null && this.labelProvider == null) {
            return;
        }
        String pattern = this.searchText.getText();
        if (pattern.length() == 0) {
            this.clearMatches();
            return;
        }
        if (!this.caseButton.getSelection()) {
            pattern = pattern.toUpperCase();
        }
        this.launchSearch(pattern, this.contentProvider.getElements(this.root));
        this.matchesLabel.setText(String.valueOf(this.matchedObjects.size()) + " matches found");
        if (!this.matchedObjects.isEmpty()) {
            this.fireSetSelection((ISelection)new StructuredSelection(this.matchedObjects.get(0)), true);
            this.nextButton.setEnabled(true);
            this.backButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
            this.backButton.setEnabled(false);
        }
    }

    protected void launchSearch(final String pattern, final Object[] root) {
        final boolean caseSensitive = this.caseButton.getSelection();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    NavigatorSearchDialog.this.matchedObjects = NavigatorSearchDialog.this.searchPattern(pattern, caseSensitive, Arrays.asList(root), monitor);
                    NavigatorSearchDialog.this.currentIndex = 0;
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected List<Object> searchPattern(String pattern, boolean caseSensitive, List<Object> objects, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ArrayList<Object> matches = new ArrayList<Object>();
        ArrayList<Object> childs = new ArrayList<Object>();
        for (Object o : objects) {
            String objectLabel;
            if (o instanceof Diagram) continue;
            String string = objectLabel = caseSensitive ? this.labelProvider.getText(o) : this.labelProvider.getText(o).toUpperCase();
            if (objectLabel.contains(pattern)) {
                matches.add(o);
            }
            EObject parentEObj = (EObject)((IAdaptable)o).getAdapter(EObject.class);
            int i = 0;
            while (i < this.contentProvider.getChildren(o).length) {
                EObject eObject;
                Object child = this.contentProvider.getChildren(o)[i];
                if (child instanceof IAdaptable && (eObject = (EObject)((IAdaptable)child).getAdapter(EObject.class)) != null && eObject.eContainer() != null && eObject.eContainer().equals(parentEObj)) {
                    childs.add(child);
                }
                ++i;
            }
        }
        if (!childs.isEmpty()) {
            matches.addAll(this.searchPattern(pattern, caseSensitive, childs, monitor));
        }
        return matches;
    }
}

