/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.dnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.core.editor.BackboneException;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.extension.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.core.extension.commands.CreationCommandRegistry;
import org.eclipse.papyrus.core.extension.commands.ICreationCommand;
import org.eclipse.papyrus.core.extension.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.modelexplorer.Activator;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonDropAdapterAssistant
extends org.eclipse.ui.navigator.CommonDropAdapterAssistant {
    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object dropTarget) {
        Object targetElement = dropTarget;
        this.execute((Command)this.getDrop(targetElement));
        return null;
    }

    protected Command getDropIntoCommand(TransactionalEditingDomain domain, EObject targetOwner, EObject childElement, EReference eref) {
        ICommand command;
        MoveRequest moveRequest = new MoveRequest(targetOwner, childElement);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetOwner);
        if (provider != null && (command = provider.getEditCommand((IEditCommandRequest)moveRequest)) != null) {
            return new GMFtoEMFCommandWrapper(command);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private static ICreationCommandRegistry getCreationCommandRegistry() {
        return CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.core");
    }

    protected Command getDropDiagramIntoCommand(TransactionalEditingDomain domain, EObject targetOwner, Diagram childElement) {
        EReference eref = NotationPackage.eINSTANCE.getView_Element();
        if (eref != null) {
            String diagType = childElement.getType();
            ICreationCommand correctCommandDescription = null;
            for (CreationCommandDescriptor desc : CommonDropAdapterAssistant.getCreationCommandRegistry().getCommandDescriptors()) {
                if (desc.getCondition() != null && !desc.getCondition().create(targetOwner)) continue;
                try {
                    ICreationCommand cmd = desc.getCommand();
                    String type = cmd.getCreatedDiagramType();
                    if (diagType != null && !diagType.equals(type)) continue;
                    correctCommandDescription = cmd;
                    break;
                }
                catch (BackboneException e) {
                    Activator.log.error((Throwable)e);
                    return UnexecutableCommand.INSTANCE;
                }
            }
            if (correctCommandDescription != null && correctCommandDescription.isParentReassignable()) {
                ICommand command;
                SetRequest setRequest = new SetRequest((EObject)childElement, (EStructuralFeature)eref, (Object)targetOwner);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)childElement);
                if (provider != null && (command = provider.getEditCommand((IEditCommandRequest)setRequest)) != null) {
                    return new GMFtoEMFCommandWrapper(command);
                }
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected SetRequest getOrderChangeCommand(TransactionalEditingDomain domain, EObject targetOwner, EObject objectLocation, EObject newElement, boolean before) {
        SetRequest setRequest = null;
        ArrayList<GMFtoEMFCommandWrapper> commandList = new ArrayList<GMFtoEMFCommandWrapper>();
        ArrayList<EStructuralFeature> possibleEFeatures = new ArrayList<EStructuralFeature>();
        EList featureList = targetOwner.eClass().getEAllStructuralFeatures();
        if (EcoreUtil.isAncestor((EObject)newElement, (EObject)targetOwner)) {
            return null;
        }
        for (EStructuralFeature eStructuralFeature : featureList) {
            EReference ref;
            if (!(eStructuralFeature instanceof EReference) || !(ref = (EReference)eStructuralFeature).isContainment() || !this.isSubClass(ref.getEType(), newElement.eClass())) continue;
            possibleEFeatures.add(eStructuralFeature);
        }
        for (EStructuralFeature eStructuralFeature : possibleEFeatures) {
            ICommand command;
            ArrayList<EObject> tmp = new ArrayList<EObject>();
            tmp.add(newElement);
            setRequest = new SetRequest(targetOwner, eStructuralFeature, tmp);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetOwner);
            if (provider == null || (command = provider.getEditCommand((IEditCommandRequest)setRequest)) == null) continue;
            commandList.add(new GMFtoEMFCommandWrapper(command));
        }
        return setRequest;
    }

    protected void execute(Command dropCommand) {
        this.getEditingDomain().getCommandStack().execute(dropCommand);
    }

    public CompoundCommand getDrop(Object target) {
        CommonDropAdapter dropAdapter = this.getCommonDropAdapter();
        List<Object> commandList = new ArrayList();
        switch (dropAdapter.getCurrentOperation()) {
            case 2: {
                if (dropAdapter.getCurrentLocation() == 1) {
                    if (!(target instanceof ModelElementItem)) break;
                    commandList = this.getOrderChangeCommand(target, true);
                    break;
                }
                if (dropAdapter.getCurrentLocation() == 2) {
                    if (!(target instanceof ModelElementItem)) break;
                    commandList = this.getOrderChangeCommand(target, false);
                    break;
                }
                if (dropAdapter.getCurrentLocation() == 3) {
                    if (target instanceof ModelElementItem) {
                        commandList = this.getDropIntoCommand(target, null);
                    }
                    if (!(target instanceof LinkItem)) break;
                    commandList = this.getDropIntoCommand(((LinkItem)target).getParent(), ((LinkItem)target).getReference());
                    break;
                }
                dropAdapter.getCurrentLocation();
            }
        }
        return new CompoundCommand(commandList);
    }

    public boolean isSubClass(EClassifier aclass, EClass possibleSubClasse) {
        if (aclass.equals(possibleSubClasse)) {
            return true;
        }
        EList superTypeList = possibleSubClasse.getEAllSuperTypes();
        return superTypeList.contains((Object)aclass);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        CompoundCommand dropCommand = this.getDrop(target);
        if (dropCommand.canExecute()) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    protected List<Command> getDropIntoCommand(Object target, EReference eref) {
        ArrayList<Command> result = new ArrayList<Command>();
        EObject targetEObject = null;
        if (target instanceof EObject) {
            targetEObject = (EObject)target;
        }
        if (target instanceof IAdaptable) {
            targetEObject = (EObject)((IAdaptable)target).getAdapter(EObject.class);
        }
        if (targetEObject == null) {
            return result;
        }
        CompoundCommand cc = new CompoundCommand();
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)selection).toList();
            ArrayList<EObject> elementsToMove = new ArrayList<EObject>();
            for (Object object : selectedElements) {
                EObject eObjectchild = null;
                if (object instanceof IAdaptable) {
                    eObjectchild = (EObject)((IAdaptable)object).getAdapter(EObject.class);
                } else if (object instanceof EObject) {
                    eObjectchild = (EObject)object;
                }
                if (eObjectchild instanceof Diagram) {
                    cc.append(this.getDropDiagramIntoCommand(this.getEditingDomain(), targetEObject, (Diagram)eObjectchild));
                    continue;
                }
                if (eObjectchild == null) continue;
                elementsToMove.add(eObjectchild);
            }
            if (elementsToMove.size() != 0) {
                MoveRequest moveRequest = new MoveRequest(targetEObject, elementsToMove);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetEObject);
                if (provider != null) {
                    ICommand command = provider.getEditCommand((IEditCommandRequest)moveRequest);
                    if (command != null) {
                        cc.append((Command)new GMFtoEMFCommandWrapper(command));
                    }
                } else {
                    cc.append((Command)UnexecutableCommand.INSTANCE);
                }
            }
        }
        result.add((Command)cc);
        return result;
    }

    protected List<Command> getOrderChangeCommand(Object target, boolean before) {
        SetRequest monoRequest;
        ArrayList<Command> result = new ArrayList<Command>();
        CompoundCommand cc = new CompoundCommand();
        ArrayList<EObject> objectToMove = new ArrayList<EObject>();
        boolean moveNeeded = false;
        ArrayList<SetRequest> monoRequestList = new ArrayList<SetRequest>();
        EObject objectLocation = null;
        EObject objectOwner = null;
        if (target instanceof IAdaptable) {
            objectLocation = (EObject)((IAdaptable)target).getAdapter(EObject.class);
            objectOwner = objectLocation.eContainer();
        }
        if (objectLocation == null) {
            return result;
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)selection).toList();
            for (Object object : selectedElements) {
                EObject eObjectchild;
                if (!(object instanceof IAdaptable) || (eObjectchild = (EObject)((IAdaptable)object).getAdapter(EObject.class)) == null || objectOwner == null) continue;
                if (!eObjectchild.eContainer().equals(objectOwner)) {
                    moveNeeded = true;
                }
                objectToMove.add(eObjectchild);
            }
        }
        if ((monoRequest = this.getOrderChangeCommand(this.getEditingDomain(), objectOwner, objectLocation, (EObject)objectToMove.get(0), before)) != null) {
            MoveRequest moveRequest;
            IElementEditService provider;
            monoRequestList.add(monoRequest);
            if (moveNeeded && (provider = ElementEditServiceUtils.getCommandProvider((Object)(moveRequest = new MoveRequest(objectOwner, objectToMove)).getTargetContainer())) != null) {
                ICommand command = provider.getEditCommand((IEditCommandRequest)moveRequest);
                cc.append((Command)new GMFtoEMFCommandWrapper(command));
            }
            ArrayList<EObject> values = new ArrayList<EObject>();
            if (objectOwner.eGet(monoRequest.getFeature()) instanceof Collection) {
                values.addAll((Collection)objectOwner.eGet(monoRequest.getFeature()));
            }
            Iterator itetToMove = objectToMove.iterator();
            int nextIndex = 1;
            while (itetToMove.hasNext()) {
                EObject currentObject = (EObject)itetToMove.next();
                if (!(objectToMove instanceof List)) continue;
                values.remove(currentObject);
                if (values.indexOf(objectLocation) == -1 || values.indexOf(objectLocation) + nextIndex > values.size()) {
                    values.add(currentObject);
                    continue;
                }
                if (before) {
                    values.add(values.indexOf(objectLocation), currentObject);
                    continue;
                }
                values.add(values.indexOf(objectLocation) + nextIndex, currentObject);
                ++nextIndex;
            }
            IElementEditService provider2 = ElementEditServiceUtils.getCommandProvider((Object)(monoRequest = new SetRequest(monoRequest.getElementToEdit(), monoRequest.getFeature(), values)).getElementToEdit());
            if (provider2 != null) {
                ICommand command = provider2.getEditCommand((IEditCommandRequest)monoRequest);
                cc.append((Command)new GMFtoEMFCommandWrapper(command));
            }
            result.add((Command)cc);
        }
        return result;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return EditorUtils.getTransactionalEditingDomain();
    }

    protected IMultiDiagramEditor getMultiDiagramEditor() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof IMultiDiagramEditor) {
            return (IMultiDiagramEditor)editorPart;
        }
        return null;
    }
}

