/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.workspace.ui.actions.RedoActionWrapper;
import org.eclipse.emf.workspace.ui.actions.UndoActionWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.modelexplorer.NavigatorUtils;
import org.eclipse.papyrus.modelexplorer.factory.IActionHandlerFactory;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DefaultEMFActionsFactory
implements IActionHandlerFactory {
    protected List<Action> actions = new LinkedList<Action>();
    protected CutAction cutAction;
    protected CopyAction copyAction;
    protected PasteAction pasteAction;
    protected UndoActionWrapper undoAction;
    protected RedoActionWrapper redoAction;
    protected LoadResourceAction loadResourceAction;

    @Override
    public List<Action> createActions(EditingDomain editingDomain) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.cutAction = new CutAction(editingDomain);
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.actions.add((Action)this.cutAction);
        this.copyAction = new CopyAction(editingDomain);
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.actions.add((Action)this.copyAction);
        this.pasteAction = new PasteAction(editingDomain);
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.actions.add((Action)this.pasteAction);
        this.undoAction = new UndoActionWrapper();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.actions.add((Action)this.undoAction);
        this.redoAction = new RedoActionWrapper();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        this.actions.add((Action)this.redoAction);
        this.loadResourceAction = new LoadResourceAction(editingDomain);
        this.actions.add((Action)this.loadResourceAction);
        return this.actions;
    }

    @Override
    public void activate(CommonNavigator activeViewPart) {
        this.cutAction.setActiveWorkbenchPart((IWorkbenchPart)activeViewPart);
        this.copyAction.setActiveWorkbenchPart((IWorkbenchPart)activeViewPart);
        this.pasteAction.setActiveWorkbenchPart((IWorkbenchPart)activeViewPart);
        this.undoAction.setActiveWorkbenchPart((IWorkbenchPart)activeViewPart);
        this.redoAction.setActiveWorkbenchPart((IWorkbenchPart)activeViewPart);
        this.loadResourceAction.setActiveWorkbenchPart((IWorkbenchPart)activeViewPart);
        CommonViewer selectionProvider = null;
        if (activeViewPart.getCommonViewer() instanceof ISelectionProvider) {
            selectionProvider = activeViewPart.getCommonViewer();
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.cutAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        }
    }

    @Override
    public void deactivate(CommonNavigator activeViewPart) {
        this.cutAction.setActiveWorkbenchPart(null);
        this.copyAction.setActiveWorkbenchPart(null);
        this.pasteAction.setActiveWorkbenchPart(null);
        this.undoAction.setActiveWorkbenchPart(null);
        this.redoAction.setActiveWorkbenchPart(null);
        this.loadResourceAction.setActiveWorkbenchPart(null);
        CommonViewer selectionProvider = null;
        if (activeViewPart.getCommonViewer() instanceof ISelectionProvider) {
            selectionProvider = activeViewPart.getCommonViewer();
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cutAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        }
    }

    @Override
    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    @Override
    public void update(IStructuredSelection structuredSelection) {
        ArrayList<EObject> array = new ArrayList<EObject>();
        for (Object object : structuredSelection) {
            if (NavigatorUtils.resolveSemanticObject(object) == null) continue;
            array.add(NavigatorUtils.resolveSemanticObject(object));
        }
        StructuredSelection st = new StructuredSelection(array);
        this.cutAction.updateSelection((IStructuredSelection)st);
        this.cutAction.setEnabled(this.cutAction.createCommand((Collection)st.toList()).canExecute());
        this.copyAction.updateSelection((IStructuredSelection)st);
        this.copyAction.setEnabled(this.copyAction.createCommand((Collection)st.toList()).canExecute());
        this.pasteAction.updateSelection((IStructuredSelection)st);
        this.pasteAction.setEnabled(this.pasteAction.createCommand((Collection)st.toList()).canExecute());
        this.loadResourceAction.update();
    }

    @Override
    public List<Action> getActions() {
        return this.actions;
    }
}

