/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.modelexplorer.NavigatorUtils;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelExplorerHandler
extends AbstractHandler {
    protected TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain editingDomain = null;
        try {
            editingDomain = ServiceUtilsForActionHandlers.getInstance().getTransactionalEditingDomain();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return editingDomain;
    }

    protected IPageMngr getPageManager() {
        IPageMngr pageMngr = null;
        try {
            pageMngr = ServiceUtilsForActionHandlers.getInstance().getIPageMngr();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return pageMngr;
    }

    protected List<Diagram> getSelectedDiagrams() {
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        ISelection selection = null;
        selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object current : structuredSelection) {
                EObject diag = NavigatorUtils.getElement(current, EObject.class);
                if (!(diag instanceof Diagram)) continue;
                diagrams.add((Diagram)diag);
            }
        }
        return diagrams;
    }
}

