/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.handler;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.modelexplorer.handler.AbstractModelExplorerHandler;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.ui.handlers.HandlerUtil;

public class CloseHandler
extends AbstractModelExplorerHandler
implements IExecutableExtension {
    public static final String PARAMETER_ALL = "all";
    public static final String PARAMETER_SELECTION = "selection";
    protected String parameter = null;
    protected String parameterID = "close_parameter";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IPageMngr pageMngr = this.getPageManager();
        if (selection instanceof IStructuredSelection && pageMngr != null) {
            if (PARAMETER_SELECTION.equals(this.parameter)) {
                Iterator iter = ((IStructuredSelection)selection).iterator();
                while (iter.hasNext()) {
                    pageMngr.closePage(iter.next());
                }
            } else if (PARAMETER_ALL.equals(this.parameter)) {
                pageMngr.closeAllOpenedPages();
            }
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Hashtable && this.parameterID != null) {
            this.parameter = (String)((Hashtable)data).get(this.parameterID);
        }
    }
}

