/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.modelexplorer.handler.AbstractCommandHandler;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;

public class DeleteCommandHandler
extends AbstractCommandHandler
implements IHandler {
    private Command deleteCommand;

    private Command buildCommand() {
        ICommand gmfCommand = null;
        HashMap parameters = new HashMap();
        for (EObject selectedEObject : this.getSelectedElements()) {
            IElementEditService provider;
            if (selectedEObject == null || (provider = ElementEditServiceUtils.getCommandProvider((Object)selectedEObject)) == null) continue;
            DestroyElementRequest request = new DestroyElementRequest(selectedEObject, false);
            request.getParameters().putAll(parameters);
            ICommand deleteCommand = provider.getEditCommand((IEditCommandRequest)request);
            gmfCommand = CompositeCommand.compose(gmfCommand, (ICommand)deleteCommand);
            parameters.clear();
            parameters.putAll(request.getParameters());
        }
        if (gmfCommand == null) {
            return UnexecutableCommand.INSTANCE;
        }
        GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(gmfCommand.reduce());
        return emfCommand;
    }

    protected Command getCommand() {
        return this.buildCommand();
    }

    public boolean isEnabled() {
        List<EObject> selectedElements = this.getSelectedElements();
        for (EObject current : selectedElements) {
            if (DeleteCommandHandler.isReadOnly(current)) {
                return false;
            }
            if (current.eContainer() != null) continue;
            return false;
        }
        return selectedElements.size() != 0;
    }

    public static boolean isReadOnly(EObject eObject) {
        if (eObject != null) {
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
            return DeleteCommandHandler.isReadOnly(eObject, domain);
        }
        return false;
    }

    public static boolean isReadOnly(EObject eObject, EditingDomain domain) {
        return DeleteCommandHandler.isReadOnly(eObject.eResource(), domain);
    }

    public static boolean isReadOnly(Resource resource, EditingDomain domain) {
        if (domain instanceof AdapterFactoryEditingDomain) {
            return ((AdapterFactoryEditingDomain)domain).isReadOnly(resource);
        }
        if (resource == null) {
            return false;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return false;
        }
        Map attributes = resourceSet.getURIConverter().getAttributes(resource.getURI(), null);
        Boolean readOnly = (Boolean)attributes.get("readOnly");
        return readOnly == null ? false : readOnly;
    }
}

