/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.handler;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.modelexplorer.handler.AbstractCommandHandler;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;

public class DeleteDiagramHandler
extends AbstractCommandHandler {
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        final IPageMngr pageMngr = this.getPageManager();
        List<Diagram> diagrams = this.getSelectedDiagrams();
        if (editingDomain != null && pageMngr != null && !diagrams.isEmpty()) {
            CompoundCommand command = new CompoundCommand();
            for (final Diagram diagram : diagrams) {
                RecordingCommand sashRemoveComd = new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        if (pageMngr.isOpen((Object)diagram)) {
                            pageMngr.closePage((Object)diagram);
                        }
                        pageMngr.removePage((Object)diagram);
                    }
                };
                EList diags = diagram.eResource().getContents();
                command.append((Command)sashRemoveComd);
                command.append((Command)new RemoveCommand((EditingDomain)editingDomain, diags, (Object)diagram));
            }
            return command.isEmpty() ? UnexecutableCommand.INSTANCE : command;
        }
        return UnexecutableCommand.INSTANCE;
    }
}

