/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.Messages;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.browser.custom.ui.dialogs.LoadCustomizationsDialog;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizationManager;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.core.utils.DiResourceSet;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.core.utils.ServiceUtils;
import org.eclipse.papyrus.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.modelexplorer.Activator;
import org.eclipse.papyrus.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.modelexplorer.NavigatorUtils;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonNavigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBrowserCustomization
extends AbstractHandler {
    protected CommonNavigator getCommonNavigator() {
        IViewPart page;
        IViewPart part = NavigatorUtils.findViewPart("org.eclipse.papyrus.modelexplorer.modelexplorer");
        if (part instanceof ModelExplorerPageBookView && (page = ((ModelExplorerPageBookView)part).getActiveView()) instanceof CommonNavigator) {
            return (CommonNavigator)page;
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (Activator.getDefault().getCustomizationManager() != null) {
            CustomizationManager customizationManager = Activator.getDefault().getCustomizationManager();
            List registeredCustomizations = customizationManager.getRegisteredCustomizations();
            LoadCustomizationsDialog loadCustomizationsDialog = new LoadCustomizationsDialog(new Shell(), registeredCustomizations, this.getMetamodels());
            if (loadCustomizationsDialog.open() == 0) {
                try {
                    customizationManager.clearCustomizations();
                    List selectedCustomizations = loadCustomizationsDialog.getSelectedCustomizations();
                    customizationManager.clearFacets();
                    if (loadCustomizationsDialog.isLoadRequiredFacetsSelected()) {
                        this.loadFacetsForCustomizations(selectedCustomizations, customizationManager);
                    }
                    for (MetamodelView metamodelView : selectedCustomizations) {
                        customizationManager.registerCustomization(metamodelView);
                    }
                    customizationManager.loadCustomizations();
                    if (this.getCommonNavigator() != null) {
                        Tree tree = this.getCommonNavigator().getCommonViewer().getTree();
                        customizationManager.installCustomPainter(tree);
                        tree.redraw();
                    }
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
            if (this.getCommonNavigator() != null) {
                this.getCommonNavigator().getCommonViewer().refresh();
            }
        }
        return null;
    }

    private DiResourceSet getDiResourceSet() {
        return EditorUtils.getDiResourceSet();
    }

    protected void loadFacetsForCustomizations(List<MetamodelView> customizations, CustomizationManager customizationManager) {
        HashSet<Facet> referencedFacets = new HashSet<Facet>();
        Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
        for (MetamodelView customization : customizations) {
            String metamodelURI = customization.getMetamodelURI();
            FacetSet customizedFacetSet = null;
            if (metamodelURI != null) {
                for (FacetSet facetSet : facetSets) {
                    if (!metamodelURI.equals(facetSet.getNsURI())) continue;
                    customizedFacetSet = facetSet;
                    break;
                }
            }
            if (customizedFacetSet == null) continue;
            EList types = customization.getTypes();
            for (TypeView typeView : types) {
                String metaclassName = typeView.getMetaclassName();
                Facet facet = this.findFacetWithFullyQualifiedName(metaclassName, customizedFacetSet);
                if (facet != null) {
                    referencedFacets.add(facet);
                    continue;
                }
                Activator.log.warn(NLS.bind((String)Messages.BrowserActionBarContributor_missingRequiredFacet, (Object[])new Object[]{metaclassName, customizedFacetSet.getName(), customization.getName()}));
            }
            for (Facet referencedFacet : referencedFacets) {
                customizationManager.loadFacet(referencedFacet);
            }
        }
    }

    private Facet findFacetWithFullyQualifiedName(String metaclassName, FacetSet customizedFacetSet) {
        EList facets = customizedFacetSet.getFacets();
        for (Facet facet : facets) {
            String facetName = LoadBrowserCustomization.getMetaclassQualifiedName((EClassifier)facet);
            if (!metaclassName.equals(facetName)) continue;
            return facet;
        }
        return null;
    }

    public static String getMetaclassQualifiedName(EClassifier eClass) {
        ArrayList<String> qualifiedNameParts = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null) {
            qualifiedNameParts.add(ePackage.getName());
            ePackage = ePackage.getESuperPackage();
        }
        int i = qualifiedNameParts.size() - 1;
        while (i >= 0) {
            builder.append(String.valueOf((String)qualifiedNameParts.get(i)) + ".");
            --i;
        }
        builder.append(eClass.getName());
        return builder.toString();
    }

    public String getMetamodelURI() {
        try {
            EObject eObject;
            EClass eClass;
            EList contents = this.getDiResourceSet().getModelResource().getContents();
            if (contents.size() > 0 && (eClass = (eObject = (EObject)contents.get(0)).eClass()) != null) {
                return eClass.getEPackage().getNsURI();
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return "";
    }

    public List<EPackage> getMetamodels() {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        ServicesRegistry serviceRegistry = null;
        try {
            serviceRegistry = ServiceUtilsForActionHandlers.getInstance().getServiceRegistry();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        IPageMngr pageMngr = null;
        try {
            pageMngr = ServiceUtils.getInstance().getIPageMngr((Object)serviceRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        List pages = pageMngr.allPages();
        int i = 0;
        while (i < pages.size()) {
            EPackage ePackage;
            if (pages.get(i) instanceof EObject && !ePackages.contains(ePackage = ((EObject)pages.get(i)).eClass().getEPackage())) {
                ePackages.add(ePackage);
            }
            ++i;
        }
        try {
            EObject eObject;
            EClass eClass;
            EList contents = this.getDiResourceSet().getModelResource().getContents();
            if (contents.size() > 0 && (eClass = (eObject = (EObject)contents.get(0)).eClass()) != null) {
                ePackages.add(eClass.getEPackage());
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return ePackages;
    }
}

