/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.handler;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.modelexplorer.handler.AbstractModelExplorerHandler;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenHandler
extends AbstractModelExplorerHandler
implements IExecutableExtension {
    public static final String PARAMETER_CLOSE = "close";
    public static final String PARAMETER_ALREADY_OPEN = "already_open";
    protected String parameterID = "open_parameter";
    protected String parameter = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IPageMngr pageMngr = this.getPageManager();
        if (selection instanceof IStructuredSelection && pageMngr != null) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                pageMngr.openPage(iter.next());
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IPageMngr pageMngr = this.getPageManager();
        if (pageMngr != null) {
            IStructuredSelection selection = this.getSelectedElement();
            Iterator iter = selection.iterator();
            if (PARAMETER_CLOSE.equals(this.parameter)) {
                while (iter.hasNext()) {
                    if (!pageMngr.isOpen(iter.next())) continue;
                    return false;
                }
                return true;
            }
            if (PARAMETER_ALREADY_OPEN.equals(this.parameter)) {
                while (iter.hasNext()) {
                    if (!pageMngr.isOpen(iter.next())) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Hashtable && this.parameterID != null) {
            this.parameter = (String)((Hashtable)data).get(this.parameterID);
        }
    }

    protected IStructuredSelection getSelectedElement() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }
}

