/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.modelexplorer.handler.AbstractCommandHandler;
import org.eclipse.papyrus.modelexplorer.messages.Messages;
import org.eclipse.swt.widgets.Display;

public class RenameDiagramHandler
extends AbstractCommandHandler {
    protected Command getCommand() {
        Diagram diag;
        String currentName;
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        List<Diagram> diagrams = this.getSelectedDiagrams();
        if (editingDomain != null && diagrams.size() == 1 && (currentName = (diag = diagrams.get(0)).getName()) != null) {
            AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editingDomain, "RenameDiagramCommand", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.RenameDiagramHandler_rename_an_existing_diagram, Messages.RenameDiagramHandler_new_name, currentName, null);
                    if (dialog.open() == 0) {
                        String name = dialog.getValue();
                        if (name != null && name.length() > 0) {
                            diag.setName(name);
                        }
                        return CommandResult.newOKCommandResult();
                    }
                    return CommandResult.newCancelledCommandResult();
                }
            };
            return new GMFtoEMFCommandWrapper((ICommand)cmd);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

