/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.core.ui.pagebookview.MultiViewPageBookView;
import org.eclipse.papyrus.modelexplorer.ModelExplorerView;
import org.eclipse.papyrus.modelexplorer.NavigatorUtils;
import org.eclipse.papyrus.modelexplorer.dialog.NavigatorSearchDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;

public class SearchElementHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell == null) {
            return null;
        }
        NavigatorSearchDialog dialog = new NavigatorSearchDialog(shell, this.getSelectedTreeViewer(event));
        dialog.open();
        return null;
    }

    protected TreeViewer getSelectedTreeViewer(ExecutionEvent event) {
        MultiViewPageBookView pageBookView;
        IViewPart viewPart;
        IWorkbenchPart activePart;
        if (event.getApplicationContext() instanceof EvaluationContext) {
            EvaluationContext context = (EvaluationContext)event.getApplicationContext();
            Object site = context.getVariable("activeSite");
            activePart = (IWorkbenchPart)context.getVariable("activePart");
        } else {
            activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        }
        if (activePart instanceof TreeViewer) {
            return (TreeViewer)activePart;
        }
        if (activePart instanceof MultiViewPageBookView && (viewPart = (pageBookView = (MultiViewPageBookView)activePart).getActiveView()) instanceof ModelExplorerView) {
            return ((ModelExplorerView)viewPart).getCommonViewer();
        }
        return null;
    }

    protected CommonNavigator getCommonNavigator() {
        IViewPart part = NavigatorUtils.findViewPart("org.eclipse.papyrus.modelexplorer.modelexplorer");
        if (part instanceof CommonNavigator) {
            return (CommonNavigator)part;
        }
        return null;
    }
}

