/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.modelexplorer.listener;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.modelexplorer.Activator;
import org.eclipse.papyrus.modelexplorer.Messages;
import org.eclipse.papyrus.modelexplorer.NavigatorUtils;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;

public class DoubleClickListener
implements IDoubleClickListener {
    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        IPageMngr pageMngr = null;
        try {
            pageMngr = ServiceUtilsForActionHandlers.getInstance().getIPageMngr();
        }
        catch (Exception e) {
            Activator.log.error(Messages.DoubleClickListener_Error_NoLoadManagerToOpen, (Throwable)e);
        }
        if (pageMngr != null && selection instanceof IStructuredSelection) {
            for (Object currentObject : (IStructuredSelection)selection) {
                EObject diag = NavigatorUtils.getElement(currentObject, EObject.class);
                if (!pageMngr.allPages().contains(diag)) continue;
                if (pageMngr.isOpen((Object)diag)) {
                    pageMngr.closePage((Object)diag);
                }
                pageMngr.openPage((Object)diag);
            }
        }
    }
}

