/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.navigation;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.core.extension.commands.ICreationCommand;
import org.eclipse.papyrus.core.extension.commands.ICreationCondition;
import org.eclipse.papyrus.core.utils.BusinessModelResolver;
import org.eclipse.papyrus.core.utils.DiResourceSet;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.navigation.CreatedNavigableElement;
import org.eclipse.papyrus.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.navigation.NavigableElement;
import org.eclipse.papyrus.navigation.NavigationHelper;
import org.eclipse.papyrus.ui.toolbox.dialog.InformationDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class CreateDiagramWithNavigationHandler
extends AbstractHandler {
    private ICreationCondition creationCondition;
    private ICreationCommand creationCommand;

    public CreateDiagramWithNavigationHandler(ICreationCommand creationCommand, ICreationCondition creationCondition) {
        this.creationCommand = creationCommand;
        this.creationCondition = creationCondition;
    }

    public boolean isEnabled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        NavigableElement navElement = this.getNavigableElementWhereToCreateDiagram();
        if (navElement == null) {
            InformationDialog dialog = new InformationDialog(Display.getCurrent().getActiveShell(), "Impossible diagram creation", "It is not possible to create this diagram on the selected element.", null, null, 32, 4, new String[]{IDialogConstants.OK_LABEL});
            dialog.open();
        } else {
            this.createDiagram(navElement);
        }
        return null;
    }

    private NavigableElement getNavigableElementWhereToCreateDiagram() {
        EObject selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            if (this.creationCondition.create(selectedElement)) {
                return new ExistingNavigableElement(selectedElement, null);
            }
            List<NavigableElement> navElements = NavigationHelper.getInstance().getAllNavigableElements(selectedElement);
            Collections.sort(navElements);
            for (NavigableElement navElement : navElements) {
                if (!(navElement instanceof CreatedNavigableElement) || !this.creationCondition.create(navElement.getElement())) continue;
                return navElement;
            }
        }
        return null;
    }

    private void createDiagram(NavigableElement navElement) {
        DiResourceSet diResourceSet = EditorUtils.getDiResourceSet();
        if (navElement != null && diResourceSet != null) {
            try {
                CompositeCommand command = NavigationHelper.getLinkCreateAndOpenNavigableDiagramCommand(navElement, this.creationCommand, null, diResourceSet);
                diResourceSet.getTransactionalEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private EObject getSelectedElement() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            return this.resolveSemanticObject(obj);
        }
        return null;
    }

    protected EObject resolveSemanticObject(Object object) {
        if (object instanceof EObject) {
            return (EObject)object;
        }
        Object businessObject = BusinessModelResolver.getInstance().getBusinessModel(object);
        if (businessObject instanceof EObject) {
            return (EObject)businessObject;
        }
        return null;
    }
}

