/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.navigation.decorator;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.papyrus.core.adaptor.gmf.DiagramsUtil;
import org.eclipse.papyrus.core.utils.DiResourceSet;
import org.eclipse.papyrus.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.navigation.NavigableElement;
import org.eclipse.papyrus.navigation.NavigationHelper;
import org.eclipse.papyrus.preferences.Activator;
import org.eclipse.papyrus.ui.toolbox.draw2d.ManuallyDrawnShortcutDecorationFigure;
import org.eclipse.swt.graphics.Color;

public class NavigationDecorator
extends AbstractDecorator
implements Adapter {
    private static final String EXTENSION_ID = "org.eclipse.papyrus.navigation.navigationColorProviders";
    private static final String COLORPROVIDER_ID = "navigationColorProvider";
    private static final String PROVIDER_ID = "provider";
    private static List<IColorProvider> navigationColorProviders;
    private Set<Resource> listenedNotationResources = new HashSet<Resource>();
    private ManuallyDrawnShortcutDecorationFigure shortcutFigure = new ManuallyDrawnShortcutDecorationFigure();
    private IGraphicalEditPart gep = null;
    private boolean displayOnly;
    Notifier notifier;

    static {
        IConfigurationElement[] configElements;
        navigationColorProviders = new LinkedList<IColorProvider>();
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (COLORPROVIDER_ID.equals(configElement.getName())) {
                try {
                    Object obj = configElement.createExecutableExtension(PROVIDER_ID);
                    if (obj instanceof IColorProvider) {
                        navigationColorProviders.add((IColorProvider)obj);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public NavigationDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
        decoratorTarget.installDecorator((Object)"navigationDecorator", (IDecorator)this);
        this.shortcutFigure.setVisible(false);
        String decoratorVisibility = Activator.getDefault().getPreferenceStore().getString("PAPYRUS_NAVIGATION_DECORATOR_VISIBILITY");
        this.displayOnly = "DISPLAY_ONLY".equals(decoratorVisibility);
    }

    public void deactivate() {
        super.deactivate();
        this.removeListenerFromAllResources();
    }

    public void activate() {
        EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
        if (editPart instanceof IGraphicalEditPart) {
            this.gep = (IGraphicalEditPart)editPart;
            if (editPart instanceof ShapeEditPart) {
                this.setDecoration(this.getDecoratorTarget().addShapeDecoration((IFigure)this.shortcutFigure, IDecoratorTarget.Direction.NORTH_EAST, -5, this.displayOnly));
            } else if (editPart instanceof ConnectionEditPart) {
                this.setDecoration(this.getDecoratorTarget().addConnectionDecoration((IFigure)this.shortcutFigure, 20, this.displayOnly));
            }
        }
        this.refresh();
    }

    public void refresh() {
        if (this.gep != null) {
            View view = this.gep.getNotationView();
            EObject element = this.gep.resolveSemanticElement();
            this.removeListenerFromAllResources();
            Diagram currentDiagram = null;
            if (view != null) {
                currentDiagram = view.getDiagram();
            }
            if (currentDiagram != null) {
                this.addResourceListener(currentDiagram.eResource());
            }
            List<NavigableElement> navElements = NavigationHelper.getInstance().getAllNavigableElements(element);
            Color shortcutColor = null;
            for (NavigableElement navElement : navElements) {
                EObject eObj;
                Resource res;
                if (!(navElement instanceof ExistingNavigableElement) || (res = (eObj = navElement.getElement()).eResource()) == null || !(res.getResourceSet() instanceof DiResourceSet)) continue;
                Resource notationResource = ((DiResourceSet)res.getResourceSet()).getAssociatedNotationResource(eObj);
                this.addResourceListener(notationResource);
                List associatedDiagrams = DiagramsUtil.getAssociatedDiagramsFromNotationResource((EObject)eObj, (Resource)notationResource);
                if (associatedDiagrams == null) continue;
                block1: for (Diagram diag : associatedDiagrams) {
                    this.addResourceListener(diag.eResource());
                    if (diag.equals(currentDiagram)) continue;
                    for (IColorProvider provider : navigationColorProviders) {
                        Color color = provider.getBackground((Object)navElement);
                        if (color == null) continue;
                        if (shortcutColor == null) {
                            shortcutColor = color;
                            continue block1;
                        }
                        if (shortcutColor.equals((Object)color)) continue block1;
                        shortcutColor = ColorConstants.white;
                        continue block1;
                    }
                }
            }
            if (shortcutColor == null) {
                this.shortcutFigure.setVisible(false);
            } else {
                this.shortcutFigure.setVisible(true);
                this.shortcutFigure.setBackgroundColor(shortcutColor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceListener(Resource r) {
        if (r != null) {
            Set<Resource> set = this.listenedNotationResources;
            synchronized (set) {
                if (this.listenedNotationResources.add(r)) {
                    r.eAdapters().add((Object)this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListenerFromAllResources() {
        Set<Resource> set = this.listenedNotationResources;
        synchronized (set) {
            for (Resource r : this.listenedNotationResources) {
                r.eAdapters().remove((Object)this);
            }
            this.listenedNotationResources.clear();
        }
    }

    public void notifyChanged(Notification notification) {
        if (!notification.isTouch() && notification.getFeatureID(Resource.class) == 2) {
            this.refresh();
        }
    }

    public Notifier getTarget() {
        return this.notifier;
    }

    public void setTarget(Notifier newTarget) {
        this.notifier = newTarget;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }
}

