/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.navigation.handlers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.core.adaptor.gmf.DiagramsUtil;
import org.eclipse.papyrus.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.core.utils.OpenDiagramCommand;
import org.eclipse.papyrus.navigation.Activator;
import org.eclipse.papyrus.navigation.utils.MultiDiagramDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpNavigateHandler
extends AbstractHandler {
    private IEditorPart editor;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (this.editor instanceof CoreMultiDiagramEditor) {
            CoreMultiDiagramEditor papyrusEditor = (CoreMultiDiagramEditor)this.editor;
            EObject parent = papyrusEditor.getDiagram().getElement().eContainer();
            List diagrams = Collections.emptyList();
            if (parent != null) {
                while (parent != null && diagrams.size() == 0) {
                    diagrams = DiagramsUtil.getAssociatedDiagrams((EObject)parent, null);
                    parent = parent.eContainer();
                }
                this.openDialog(papyrusEditor, diagrams);
            }
        }
        return null;
    }

    private void openDialog(CoreMultiDiagramEditor papyrusEditor, List<Diagram> diagrams) {
        if (diagrams != null) {
            MultiDiagramDialog multiDiagramDialog;
            if (diagrams.size() == 1) {
                this.openDiagram(papyrusEditor, diagrams.get(0));
            } else if (diagrams.size() > 1 && (multiDiagramDialog = new MultiDiagramDialog(Activator.getActiveWorkbenchShell(), diagrams)).open() == 0) {
                this.openDiagram(papyrusEditor, diagrams.get(multiDiagramDialog.getSelectedDiagram()));
            }
        }
    }

    private void openDiagram(CoreMultiDiagramEditor papyrusEditor, Diagram diagram) {
        if (papyrusEditor.getEditingDomain() instanceof TransactionalEditingDomain) {
            TransactionalEditingDomain domain = (TransactionalEditingDomain)papyrusEditor.getEditingDomain();
            OpenDiagramCommand openDiagramCommand = new OpenDiagramCommand(domain, (EObject)diagram);
            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)openDiagramCommand));
        }
    }
}

