/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.onefile.model.mapping;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.onefile.model.PapyrusModelHelper;
import org.eclipse.papyrus.onefile.providers.OneFileModelProvider;

public class PapyrusResourceMapping
extends ResourceMapping {
    private final IPapyrusFile papyrusFile;

    public PapyrusResourceMapping(IPapyrusFile adaptableObject) {
        this.papyrusFile = adaptableObject;
    }

    public PapyrusResourceMapping(IFile resource) {
        this.papyrusFile = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(resource);
    }

    public Object getModelObject() {
        return this.papyrusFile;
    }

    public String getModelProviderId() {
        return OneFileModelProvider.MODEL_PROVIDER_ID;
    }

    public IProject[] getProjects() {
        return new IProject[]{this.papyrusFile.getProject()};
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        return new ResourceTraversal[]{new ResourceTraversal(this.papyrusFile.getAssociatedResources(), 2, 0)};
    }

    public void accept(ResourceMappingContext context, IResourceVisitor visitor, IProgressMonitor monitor) throws CoreException {
        super.accept(context, visitor, monitor);
    }
}

