/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.onefile.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.onefile.model.IPapyrusFile;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecorationBuilder;

public class OneFileDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IPapyrusFile) {
            IPapyrusFile papy = (IPapyrusFile)element;
            IResource[] associatedResources = papy.getAssociatedResources();
            FilteredDecorationBuilder builder = new FilteredDecorationBuilder(decoration.getDecorationContext(), associatedResources.length);
            IResource[] iResourceArray = associatedResources;
            int n = associatedResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                WorkbenchPlugin.getDefault().getDecoratorManager().getLightweightManager().getDecorations((Object)r, (DecorationBuilder)builder);
                ++n2;
            }
            builder.handleDecoration(decoration);
        }
    }

    protected class FilteredDecorationBuilder
    extends DecorationBuilder {
        private Map<ImageDescriptor, Integer> overlay;
        private Map<String, Integer> prefixString;
        private Map<String, Integer> suffixString;
        private Color bgColor;
        private boolean flagBgColor;
        private Font newFont;
        private boolean flagNewFont;
        private Color fgColor;
        private boolean flagFgColor;
        private final int nbResource;

        public FilteredDecorationBuilder(IDecorationContext context, int nbResource) {
            super(context);
            this.overlay = new HashMap<ImageDescriptor, Integer>();
            this.prefixString = new HashMap<String, Integer>();
            this.suffixString = new HashMap<String, Integer>();
            this.bgColor = null;
            this.flagBgColor = false;
            this.newFont = null;
            this.flagNewFont = false;
            this.fgColor = null;
            this.flagFgColor = false;
            this.nbResource = nbResource;
        }

        public void addOverlay(ImageDescriptor overlay) {
            Integer result = this.overlay.get(overlay);
            if (result == null) {
                result = 0;
            }
            result = result + 1;
            this.overlay.put(overlay, result);
        }

        public void addPrefix(String prefixString) {
            Integer result = this.prefixString.get(prefixString);
            if (result == null) {
                result = 0;
            }
            result = result + 1;
            this.prefixString.put(prefixString, result);
        }

        public void addSuffix(String suffixString) {
            Integer result = this.suffixString.get(suffixString);
            if (result == null) {
                result = 0;
            }
            result = result + 1;
            this.suffixString.put(suffixString, result);
        }

        public void setBackgroundColor(Color bgColor) {
            if (this.bgColor == null && !this.flagBgColor) {
                this.bgColor = bgColor;
                this.flagBgColor = true;
            } else if (this.bgColor != null && !this.bgColor.equals((Object)bgColor)) {
                this.bgColor = null;
            }
        }

        public void setFont(Font newFont) {
            if (this.newFont == null && !this.flagNewFont) {
                this.newFont = newFont;
                this.flagNewFont = true;
            } else if (this.newFont != null && !this.newFont.equals((Object)newFont)) {
                this.newFont = null;
            }
        }

        public void setForegroundColor(Color fgColor) {
            if (this.fgColor == null && !this.flagFgColor) {
                this.fgColor = fgColor;
                this.flagFgColor = true;
            } else if (this.fgColor != null && !this.fgColor.equals((Object)fgColor)) {
                this.fgColor = null;
            }
        }

        public void handleDecoration(IDecoration decoration) {
            if (this.fgColor != null) {
                decoration.setForegroundColor(this.fgColor);
            }
            if (this.bgColor != null) {
                decoration.setBackgroundColor(this.bgColor);
            }
            if (this.newFont != null) {
                decoration.setFont(this.newFont);
            }
            for (ImageDescriptor desc : this.overlay.keySet()) {
                if (this.overlay.get(desc) != this.nbResource) continue;
                decoration.addOverlay(desc);
            }
            for (String s : this.prefixString.keySet()) {
                if (this.prefixString.get(s) != this.nbResource) continue;
                decoration.addPrefix(s);
            }
            for (String s : this.suffixString.keySet()) {
                if (this.suffixString.get(s) != this.nbResource) continue;
                decoration.addSuffix(s);
            }
        }
    }
}

