/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.onefile.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.onefile.model.PapyrusModelHelper;
import org.eclipse.papyrus.onefile.utils.OneFileUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.navigator.CommonViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusContentProvider
extends WorkbenchContentProvider {
    private CommonViewer common;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (viewer instanceof CommonViewer) {
            this.common = (CommonViewer)viewer;
        }
    }

    public boolean isFiltered() {
        return this.common != null && this.common.getNavigatorContentService() != null && this.common.getNavigatorContentService().getFilterService() != null && this.common.getNavigatorContentService().getFilterService().isActive("org.eclipse.papyrus.onefile.onlyDiFilter");
    }

    public void dispose() {
        super.dispose();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            return null;
        }
        LinkedList<Object> result = new LinkedList<Object>();
        try {
            if (this.isFiltered()) {
                if (inputElement instanceof IPapyrusFile) {
                    IPapyrusFile file = (IPapyrusFile)inputElement;
                    IResource[] iResourceArray = file.getAssociatedResources();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource r = iResourceArray[n2];
                        result.add(PapyrusModelHelper.getPapyrusModelFactory().createISubResourceFile(file, (IFile)r));
                        ++n2;
                    }
                } else {
                    IResource[] members = null;
                    if (inputElement instanceof IContainer) {
                        members = ((IContainer)inputElement).members();
                    }
                    if (members != null) {
                        IResource[] iResourceArray = members;
                        int n = members.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IResource r = iResourceArray[n3];
                            if (r instanceof IContainer && !(r instanceof IProject)) {
                                IContainer cont = (IContainer)r;
                                result.add(cont);
                            } else if (r instanceof IFile) {
                                if (OneFileUtils.isDi(r)) {
                                    IPapyrusFile createIPapyrusFile = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile((IFile)r);
                                    result.add(createIPapyrusFile);
                                } else if (!OneFileUtils.diExists(r.getName(), r.getParent())) {
                                    result.add(r);
                                }
                            } else {
                                result.add(r);
                            }
                            ++n3;
                        }
                    }
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result.isEmpty() ? null : result.toArray();
    }

    public Object[] getChildren(Object inputElement) {
        return this.getElements(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof IPapyrusFile) {
            IPapyrusFile papyFile = (IPapyrusFile)element;
            return papyFile.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return OneFileUtils.hasChildren(element);
    }

    protected void processDelta(IResourceDelta delta) {
        super.processDelta(delta);
        if (!this.isFiltered()) {
            return;
        }
        Control ctrl = this.common.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        final ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        this.processPapyrusDelta(delta, runnables);
        if (runnables.isEmpty()) {
            return;
        }
        ctrl.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Control ctrl = PapyrusContentProvider.this.common.getControl();
                if (ctrl == null || ctrl.isDisposed()) {
                    return;
                }
                PapyrusContentProvider.this.runUpdates(runnables);
            }
        });
    }

    private void runUpdates(Collection<?> runnables) {
        Iterator<?> runnableIterator = runnables.iterator();
        while (runnableIterator.hasNext()) {
            ((Runnable)runnableIterator.next()).run();
        }
    }

    protected void processPapyrusDelta(IResourceDelta delta, Collection<Runnable> runnables) {
        Object[] addedObjects;
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i = 0;
        while (i < affectedChildren.length) {
            this.processPapyrusDelta(affectedChildren[i], runnables);
            ++i;
        }
        IResourceDelta[] addedChildren = delta.getAffectedChildren(1);
        if (addedChildren.length > 0) {
            addedObjects = new Object[addedChildren.length];
            int i2 = 0;
            while (i2 < addedChildren.length) {
                addedObjects[i2] = addedChildren[i2].getResource();
                ++i2;
            }
        } else {
            addedObjects = new Object[]{};
        }
        Runnable addAndRemove = new Runnable(){

            public void run() {
                if (PapyrusContentProvider.this.common instanceof AbstractTreeViewer) {
                    CommonViewer treeViewer = PapyrusContentProvider.this.common;
                    if (addedObjects.length > 0) {
                        ArrayList<IPapyrusFile> elements = new ArrayList<IPapyrusFile>(addedObjects.length);
                        ArrayList<IPapyrusFile> toAdd = new ArrayList<IPapyrusFile>(addedObjects.length);
                        Object[] objectArray = addedObjects;
                        int n = addedObjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            if (object instanceof IResource) {
                                IResource current = (IResource)object;
                                if (OneFileUtils.diExists(current.getName(), current.getParent())) {
                                    elements.add(PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(OneFileUtils.getDi(current.getName(), current.getParent())));
                                }
                                if (OneFileUtils.isDi(current)) {
                                    toAdd.add(PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile((IFile)current));
                                }
                            }
                            ++n2;
                        }
                        for (Object e : elements) {
                            PapyrusContentProvider.this.common.refresh(e);
                        }
                        for (IPapyrusFile iPapyrusFile : toAdd) {
                            PapyrusContentProvider.this.common.add((Object)iPapyrusFile.getParent(), (Object)iPapyrusFile);
                        }
                    }
                }
            }
        };
        runnables.add(addAndRemove);
    }
}

