/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.outline;

import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.swt.graphics.Image;

public class DiagramOrientedLabelProvider
implements ILabelProvider {
    private AdapterFactoryLabelProvider myAdapterFactoryLabelProvider;
    private IPageIconsRegistry editorRegistry;

    public DiagramOrientedLabelProvider(AdapterFactoryLabelProvider adapterFactoryLabelProvider) {
        this.myAdapterFactoryLabelProvider = adapterFactoryLabelProvider;
    }

    public Image getImage(Object element) {
        if (element instanceof Diagram) {
            return this.getEditorRegistry().getEditorIcon(element);
        }
        return this.myAdapterFactoryLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof Diagram) {
            Diagram diagram = (Diagram)element;
            return this.myAdapterFactoryLabelProvider.getText((Object)diagram.getElement());
        }
        return this.myAdapterFactoryLabelProvider.getText(element);
    }

    public void addListener(ILabelProviderListener listener) {
        this.myAdapterFactoryLabelProvider.addListener(listener);
    }

    public void dispose() {
        this.myAdapterFactoryLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.myAdapterFactoryLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.myAdapterFactoryLabelProvider.removeListener(listener);
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)EditorUtils.getServiceRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }
}

