/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.outline;

import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.papyrus.core.contentoutline.IPapyrusContentOutlinePage;
import org.eclipse.papyrus.core.editor.BackboneException;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.outline.DiagramNavigator;
import org.eclipse.papyrus.outline.internal.Messages;
import org.eclipse.papyrus.outline.overview.OverviewComposite;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DiagramOutline
extends Page
implements IPapyrusContentOutlinePage,
ISelectionListener {
    protected EditingDomain editingDomain;
    private IMultiDiagramEditor multiEditor;
    private SashForm sashComp;
    private DiagramNavigator navigator;
    private RenderedDiagramRootEditPart root = null;
    private Diagram diagram = null;
    public static final int SHOW_TREE = 1;
    public static final int SHOW_OVERVIEW = 2;
    public static final int SHOW_BOTH = 0;
    private Composite overview;
    private IAction showTreeAction;
    private IAction showOverviewAction;
    private IAction showAllAction;

    public void init(IMultiDiagramEditor multiEditor) throws BackboneException {
        try {
            this.editingDomain = (EditingDomain)multiEditor.getServicesRegistry().getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            throw new BackboneException("Can't get TransactionalEditingDomain", (Throwable)e);
        }
        this.multiEditor = multiEditor;
        multiEditor.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    public void createControl(Composite parent) {
        this.sashComp = new SashForm(parent, 512);
        this.sashComp.setLayoutData((Object)new GridData(1808));
        this.refreshSelection();
        if (this.root != null) {
            this.overview = this.createOverview((Composite)this.sashComp, (ScalableFreeformRootEditPart)this.root);
            this.overview.setLayoutData((Object)new GridData(1808));
        }
        this.navigator = this.createNavigator((Composite)this.sashComp, this.getSite());
        if (this.diagram != null) {
            this.navigator.getTreeViewer().setInput((Object)this.diagram);
        }
        if (this.overview != null) {
            this.sashComp.setWeights(new int[]{30, 70});
        }
        this.createActions();
    }

    protected Composite createOverview(Composite parent, ScalableFreeformRootEditPart rootEditPart) {
        return new OverviewComposite(parent, rootEditPart);
    }

    protected void createActions() {
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        tbm.add((IContributionItem)new Separator());
        this.createShowOutlineActions(tbm);
    }

    private void createShowOutlineActions(IToolBarManager tbm) {
        this.showTreeAction = new Action(Messages.DiagramOutline_ShowNavigator, 8){

            public void run() {
                if (DiagramOutline.this.navigator != null && !DiagramOutline.this.navigator.isDisposed()) {
                    DiagramOutline.this.performShowAction();
                }
            }
        };
        this.showTreeAction.setToolTipText(this.showTreeAction.getText());
        this.showTreeAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.outline", (String)"icons/elcl16/tree_co.gif"));
        tbm.add(this.showTreeAction);
        this.showOverviewAction = new Action(Messages.DiagramOutline_ShowOverview, 8){

            public void run() {
                if (DiagramOutline.this.overview != null && !DiagramOutline.this.overview.isDisposed()) {
                    DiagramOutline.this.performShowAction();
                }
            }
        };
        this.showOverviewAction.setToolTipText(this.showOverviewAction.getText());
        this.showOverviewAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.outline", (String)"icons/elcl16/overview_co.gif"));
        tbm.add(this.showOverviewAction);
        this.showAllAction = new Action(Messages.DiagramOutline_ShowBoth, 8){

            public void run() {
                if (DiagramOutline.this.sashComp != null && !DiagramOutline.this.sashComp.isDisposed()) {
                    DiagramOutline.this.performShowAction();
                }
            }
        };
        this.showAllAction.setToolTipText(this.showAllAction.getText());
        this.showAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.outline", (String)"icons/elcl16/all_co.gif"));
        tbm.add(this.showAllAction);
        this.showOverviewAction.setChecked(true);
        this.performShowAction();
    }

    private DiagramNavigator createNavigator(Composite parent, IPageSite pageSite) {
        return new DiagramNavigator(parent, pageSite);
    }

    public Control getControl() {
        return this.sashComp;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.navigator != null && !this.navigator.isDisposed()) {
            this.navigator.getTreeViewer().addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        return this.navigator.getTreeViewer().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.navigator != null && !this.navigator.isDisposed()) {
            this.navigator.getTreeViewer().removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this.navigator.getTreeViewer().setSelection(selection);
    }

    public void dispose() {
        super.dispose();
        if (this.navigator != null) {
            this.navigator.dispose();
        }
        if (this.overview != null) {
            this.overview.dispose();
        }
        if (this.multiEditor != null) {
            this.multiEditor.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.refreshSelection();
        this.refresh();
    }

    private void refreshSelection() {
        if (this.multiEditor.getActiveEditor() != null) {
            GraphicalViewer viewer = (GraphicalViewer)this.multiEditor.getActiveEditor().getAdapter(GraphicalViewer.class);
            if (viewer == null) {
                this.root = null;
                this.diagram = null;
                return;
            }
            RootEditPart rootEditPart = viewer.getRootEditPart();
            if (rootEditPart instanceof RenderedDiagramRootEditPart) {
                this.root = (RenderedDiagramRootEditPart)rootEditPart;
                this.diagram = rootEditPart.getContents() != null ? (Diagram)rootEditPart.getContents().getModel() : null;
            } else {
                this.root = null;
                this.diagram = null;
            }
        } else {
            this.root = null;
            this.diagram = null;
        }
    }

    private void refresh() {
        if (this.overview != null && !this.overview.isDisposed()) {
            this.overview.dispose();
        }
        if (this.root != null) {
            this.overview = this.createOverview((Composite)this.sashComp, (ScalableFreeformRootEditPart)this.root);
            this.overview.setLayoutData((Object)new GridData(1808));
        }
        if (this.diagram != null) {
            this.navigator.getTreeViewer().setInput((Object)this.diagram);
        }
        if (this.overview != null && !this.overview.isDisposed()) {
            this.sashComp.setWeights(new int[]{30, 70});
        }
        this.performShowAction();
    }

    private void performShowAction() {
        DiagramNavigator control = null;
        control = null;
        switch (this.getShowActionMode()) {
            case 1: {
                control = this.navigator;
                break;
            }
            case 2: {
                control = this.overview;
                break;
            }
            case 0: {
                control = null;
                break;
            }
            default: {
                control = this.overview;
            }
        }
        if (this.sashComp != null && !this.sashComp.isDisposed()) {
            this.sashComp.setMaximizedControl((Control)control);
        }
    }

    private int getShowActionMode() {
        int showActionMode = -1;
        if (this.showTreeAction.isChecked()) {
            showActionMode = 1;
        }
        if (this.showOverviewAction.isChecked()) {
            showActionMode = 2;
        }
        if (this.showAllAction.isChecked()) {
            showActionMode = 0;
        }
        return showActionMode;
    }
}

