/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.paletteconfiguration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ToolKind implements Enumerator
{
    CREATION_TOOL(0, "CreationTool", "CreationTool"),
    CONNECTION_TOOL(1, "ConnectionTool", "ConnectionTool");

    public static final int CREATION_TOOL_VALUE = 0;
    public static final int CONNECTION_TOOL_VALUE = 1;
    private static final ToolKind[] VALUES_ARRAY;
    public static final List<ToolKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ToolKind[]{CREATION_TOOL, CONNECTION_TOOL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ToolKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ToolKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ToolKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ToolKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ToolKind get(int value) {
        switch (value) {
            case 0: {
                return CREATION_TOOL;
            }
            case 1: {
                return CONNECTION_TOOL;
            }
        }
        return null;
    }

    private ToolKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

