/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parameter.editor.xtext.ui.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.common.editor.xtext.umlCommon.TypeRule;
import org.eclipse.papyrus.parameter.editor.xtext.ui.contentassist.AbstractUmlParameterProposalProvider;
import org.eclipse.papyrus.parameter.editor.xtext.ui.contributions.UMLParameterEditorUtil;
import org.eclipse.papyrus.parameter.editor.xtext.umlParameter.ModifierSpecification;
import org.eclipse.papyrus.parameter.editor.xtext.umlParameter.ModifiersRule;
import org.eclipse.papyrus.parameter.editor.xtext.umlParameter.ParameterRule;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class UmlParameterProposalProvider
extends AbstractUmlParameterProposalProvider {
    public void completeParameterRule_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ArrayList allType = new ArrayList();
        allType.addAll(this.getRecursivelyOwnedType(this.getModel()));
        allType.addAll(this.getRecursivelyImportedType(this.getModel()));
        for (Type c : allType) {
            if (!c.getName().contains(context.getPrefix())) continue;
            String displayString = c.getQualifiedName();
            String completionString = UMLParameterEditorUtil.getTypeLabel(c, this.getModel());
            ICompletionProposal completionProposal = this.createCompletionProposalWithReplacementOfPrefix((NamedElement)c, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
        this.completeRuleCall((RuleCall)assignment.getTerminal(), context, acceptor);
    }

    public void completeTypeRule_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!(model instanceof ParameterRule)) {
            return;
        }
        super.completeTypeRule_Type(model, assignment, context, acceptor);
    }

    public void complete_MultiplicityRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof ParameterRule && !this.typeExists((ParameterRule)model)) {
            return;
        }
        super.complete_MultiplicityRule(model, ruleCall, context, acceptor);
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        EObject model = contentAssistContext.getCurrentModel();
        if (!(model instanceof ModifiersRule)) {
            if (model instanceof ParameterRule) {
                if ("::".equals(keyword.getValue())) {
                    TypeRule typeRule = ((ParameterRule)model).getType();
                    Type type = null;
                    if (typeRule != null) {
                        type = typeRule.getType();
                    }
                    if (type != null && this.typeExists((ParameterRule)model) && type instanceof Namespace) {
                        List includedType = this.getRecursivelyOwnedType((Namespace)type);
                        includedType.addAll(this.getRecursivelyImportedType((Namespace)type));
                        if (includedType.isEmpty()) {
                            return;
                        }
                    }
                } else if ("[".equals(keyword.getValue()) ? !this.typeExists((ParameterRule)model) : ("]".equals(keyword.getValue()) ? !this.typeExists((ParameterRule)model) : "{".equals(keyword.getValue()) && !this.typeExists((ParameterRule)model))) {
                    return;
                }
            }
            super.completeKeyword(keyword, contentAssistContext, acceptor);
            return;
        }
        ModifiersRule modifiersRule = (ModifiersRule)model;
        boolean isOrdered = false;
        boolean isException = false;
        boolean isStream = false;
        boolean isUnique = false;
        for (ModifierSpecification spec : modifiersRule.getValues()) {
            if (spec.getValue() == null) continue;
            switch (spec.getValue()) {
                case ORDERED: {
                    isOrdered = true;
                    break;
                }
                case EXCEPTION: {
                    isException = true;
                    break;
                }
                case STREAM: {
                    isStream = true;
                    break;
                }
                case UNIQUE: {
                    isUnique = true;
                    break;
                }
            }
        }
        String value = keyword.getValue();
        if (value.equals("ordered")) {
            if (!isOrdered) {
                super.completeKeyword(keyword, contentAssistContext, acceptor);
            }
        } else if (value.equals("exception")) {
            if (!isException) {
                super.completeKeyword(keyword, contentAssistContext, acceptor);
            }
        } else if (value.equals("unique")) {
            if (!isUnique) {
                super.completeKeyword(keyword, contentAssistContext, acceptor);
            }
        } else if (value.equals("stream")) {
            if (!isStream) {
                super.completeKeyword(keyword, contentAssistContext, acceptor);
            }
        } else {
            super.completeKeyword(keyword, contentAssistContext, acceptor);
        }
    }

    protected boolean typeExists(ParameterRule parameterRule) {
        if (parameterRule instanceof ParameterRule) {
            ParameterRule currentModel = parameterRule;
            TypeRule ruleType = currentModel.getType();
            if (ruleType == null) {
                return true;
            }
            Type type = ruleType.getType();
            if (type == null) {
                return false;
            }
            if (type.eContainer() == null && type.getName() == null) {
                return false;
            }
        }
        return true;
    }
}

