/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.antlr;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.debug.DebugEventSocketProxy;
import org.antlr.runtime.debug.DebugParser;
import org.antlr.runtime.debug.DebugTokenStream;
import org.antlr.runtime.debug.DebugTreeAdaptor;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.papyrus.parsers.util.IErrorReporter;
import org.eclipse.papyrus.parsers.util.Messages;
import org.eclipse.papyrus.parsers.util.MultiplicityException;
import org.eclipse.papyrus.parsers.util.NameException;
import org.eclipse.papyrus.parsers.util.TypeRecognitionException;
import org.eclipse.papyrus.parsers.util.UnboundTemplateRecognitionException;
import org.eclipse.papyrus.umlutils.PackageUtil;
import org.eclipse.papyrus.umlutils.PropertyUtil;
import org.eclipse.papyrus.umlutils.TemplateSignatureUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.VisibilityKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLabelParser
extends DebugParser {
    public static final String[] tokenNames = new String[]{"<invalid>", "<EOR>", "<DOWN>", "<UP>", "WS", "COLON", "PLUS", "MINUS", "SHARP", "TILDE", "DIV", "IDENTIFIER", "LSQUARE", "RANGE_VALUE", "INTEGER", "RSQUARE", "STAR", "EQ", "LCURLY", "COMMA", "RCURLY", "NL", "QUESTION_MARK", "LNOT", "DOUBLE_QUOTE", "SINGLE_QUOTE", "LPAREN", "RPAREN", "DOUBLE_LCURLY", "DOUBLE_RCURLY", "LOGICAL_AND", "DOUBLE_LOGICAL_AND", "PIPE", "DOUBLE_PIPE", "POINT", "RANGE", "SEMI", "FOUR_POINTS", "RULE_ASSIGN", "ARROW", "ISEQ", "ISNE", "LT", "DOUBLE_LT", "LE", "GT", "DOUBLE_GT", "GE", "INCR", "DECR", "CALLOPERATION", "ALPHA", "UNDERSCORE", "REAL", "INTEGER_OR_REAL_OR_RANGE", "'<Undefined>'", "'readOnly'", "'union'", "'ordered'", "'unique'", "'nonunique'", "'subsets'", "'redefines'"};
    public static final int DOUBLE_LT = 43;
    public static final int COMMA = 19;
    public static final int ISEQ = 40;
    public static final int MINUS = 7;
    public static final int INCR = 48;
    public static final int SHARP = 8;
    public static final int T__57 = 57;
    public static final int DOUBLE_RCURLY = 29;
    public static final int DECR = 49;
    public static final int ARROW = 39;
    public static final int DOUBLE_GT = 46;
    public static final int RULE_ASSIGN = 38;
    public static final int TILDE = 9;
    public static final int PIPE = 32;
    public static final int DOUBLE_PIPE = 33;
    public static final int INTEGER = 14;
    public static final int RCURLY = 20;
    public static final int QUESTION_MARK = 22;
    public static final int NL = 21;
    public static final int LCURLY = 18;
    public static final int T__62 = 62;
    public static final int LE = 44;
    public static final int RPAREN = 27;
    public static final int T__61 = 61;
    public static final int LPAREN = 26;
    public static final int T__59 = 59;
    public static final int PLUS = 6;
    public static final int SINGLE_QUOTE = 25;
    public static final int REAL = 53;
    public static final int T__56 = 56;
    public static final int LSQUARE = 12;
    public static final int RANGE = 35;
    public static final int FOUR_POINTS = 37;
    public static final int DOUBLE_LCURLY = 28;
    public static final int POINT = 34;
    public static final int WS = 4;
    public static final int ALPHA = 51;
    public static final int T__58 = 58;
    public static final int EQ = 17;
    public static final int LT = 42;
    public static final int GT = 45;
    public static final int DOUBLE_QUOTE = 24;
    public static final int RSQUARE = 15;
    public static final int DOUBLE_LOGICAL_AND = 31;
    public static final int RANGE_VALUE = 13;
    public static final int T__55 = 55;
    public static final int SEMI = 36;
    public static final int GE = 47;
    public static final int LNOT = 23;
    public static final int ISNE = 41;
    public static final int LOGICAL_AND = 30;
    public static final int EOF = -1;
    public static final int COLON = 5;
    public static final int INTEGER_OR_REAL_OR_RANGE = 54;
    public static final int DIV = 10;
    public static final int IDENTIFIER = 11;
    public static final int STAR = 16;
    public static final int T__60 = 60;
    public static final int UNDERSCORE = 52;
    public static final int CALLOPERATION = 50;
    public static final String[] ruleNames = new String[]{"invalidRule", "property_type", "type", "expression", "subsetsProperty", "isDerived", "defaultValue", "upperMultiplicity", "unlimitedNatural", "fullMultiplicity", "redefinesProperty", "lowerMultiplicity", "label", "propertyModifiers", "visibility", "propertyModifier", "name"};
    public int ruleLevel = 0;
    protected DebugTreeAdaptor adaptor;
    private boolean isValidation = false;
    private static final boolean DEBUG = false;
    private Package nearestPackage;
    private Property property;
    protected final boolean debugMode = false;
    private int context = 0;
    String name;
    VisibilityKind visibility = VisibilityKind.PUBLIC_LITERAL;
    boolean isDerived = false;
    Type type = null;
    int lowerMultiplicity = 1;
    int upperMultiplicity = 1;
    String defaultValue = null;
    boolean isReadOnly = false;
    boolean isUnique = false;
    boolean isOrdered = false;
    boolean isDerivedUnion = false;
    Collection subsettedProperties = new Vector();
    Collection redefinedProperties = new Vector();
    public Map<String, Boolean> modifiersUsed;
    private IErrorReporter errorReporter = null;
    public static final BitSet FOLLOW_WS_in_label46 = new BitSet(new long[]{4048L});
    public static final BitSet FOLLOW_visibility_in_label53 = new BitSet(new long[]{4048L});
    public static final BitSet FOLLOW_WS_in_label56 = new BitSet(new long[]{4048L});
    public static final BitSet FOLLOW_isDerived_in_label68 = new BitSet(new long[]{4048L});
    public static final BitSet FOLLOW_WS_in_label71 = new BitSet(new long[]{4048L});
    public static final BitSet FOLLOW_name_in_label83 = new BitSet(new long[]{48L});
    public static final BitSet FOLLOW_WS_in_label86 = new BitSet(new long[]{48L});
    public static final BitSet FOLLOW_COLON_in_label92 = new BitSet(new long[]{0x80000000000810L});
    public static final BitSet FOLLOW_property_type_in_label102 = new BitSet(new long[]{397314L});
    public static final BitSet FOLLOW_fullMultiplicity_in_label110 = new BitSet(new long[]{393234L});
    public static final BitSet FOLLOW_WS_in_label115 = new BitSet(new long[]{393234L});
    public static final BitSet FOLLOW_defaultValue_in_label124 = new BitSet(new long[]{262146L});
    public static final BitSet FOLLOW_propertyModifiers_in_label134 = new BitSet(new long[]{18L});
    public static final BitSet FOLLOW_WS_in_label139 = new BitSet(new long[]{18L});
    public static final BitSet FOLLOW_PLUS_in_visibility203 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_MINUS_in_visibility218 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_SHARP_in_visibility232 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_TILDE_in_visibility246 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_DIV_in_isDerived287 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_IDENTIFIER_in_name326 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_WS_in_property_type375 = new BitSet(new long[]{0x80000000000810L});
    public static final BitSet FOLLOW_type_in_property_type383 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_55_in_property_type391 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_IDENTIFIER_in_type451 = new BitSet(new long[]{2066L});
    public static final BitSet FOLLOW_WS_in_type458 = new BitSet(new long[]{2066L});
    public static final BitSet FOLLOW_IDENTIFIER_in_type475 = new BitSet(new long[]{2066L});
    public static final BitSet FOLLOW_WS_in_type484 = new BitSet(new long[]{2066L});
    public static final BitSet FOLLOW_LSQUARE_in_fullMultiplicity537 = new BitSet(new long[]{24576L});
    public static final BitSet FOLLOW_RANGE_VALUE_in_fullMultiplicity557 = new BitSet(new long[]{32768L});
    public static final BitSet FOLLOW_INTEGER_in_fullMultiplicity567 = new BitSet(new long[]{32768L});
    public static final BitSet FOLLOW_RSQUARE_in_fullMultiplicity577 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_INTEGER_in_lowerMultiplicity629 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_unlimitedNatural_in_upperMultiplicity650 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_STAR_in_unlimitedNatural678 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_INTEGER_in_unlimitedNatural693 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_EQ_in_defaultValue719 = new BitSet(new long[]{9223372036854513648L});
    public static final BitSet FOLLOW_expression_in_defaultValue725 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_set_in_expression819 = new BitSet(new long[]{9223372036854513650L});
    public static final BitSet FOLLOW_LCURLY_in_propertyModifiers868 = new BitSet(new long[]{9151314442816847888L});
    public static final BitSet FOLLOW_WS_in_propertyModifiers871 = new BitSet(new long[]{9151314442816847888L});
    public static final BitSet FOLLOW_propertyModifier_in_propertyModifiers881 = new BitSet(new long[]{0x180010L});
    public static final BitSet FOLLOW_WS_in_propertyModifiers884 = new BitSet(new long[]{0x180010L});
    public static final BitSet FOLLOW_COMMA_in_propertyModifiers903 = new BitSet(new long[]{9151314442816847888L});
    public static final BitSet FOLLOW_WS_in_propertyModifiers906 = new BitSet(new long[]{9151314442816847888L});
    public static final BitSet FOLLOW_propertyModifier_in_propertyModifiers910 = new BitSet(new long[]{0x180010L});
    public static final BitSet FOLLOW_WS_in_propertyModifiers913 = new BitSet(new long[]{0x180010L});
    public static final BitSet FOLLOW_RCURLY_in_propertyModifiers925 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_56_in_propertyModifier965 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_57_in_propertyModifier974 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_58_in_propertyModifier984 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_59_in_propertyModifier992 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_60_in_propertyModifier1001 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_61_in_propertyModifier1009 = new BitSet(new long[]{2048L});
    public static final BitSet FOLLOW_subsetsProperty_in_propertyModifier1013 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_redefinesProperty_in_propertyModifier1021 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_IDENTIFIER_in_subsetsProperty1173 = new BitSet(new long[]{2L});
    public static final BitSet FOLLOW_62_in_redefinesProperty1212 = new BitSet(new long[]{2048L});
    public static final BitSet FOLLOW_IDENTIFIER_in_redefinesProperty1218 = new BitSet(new long[]{2L});

    public int getRuleLevel() {
        return this.ruleLevel;
    }

    public void incRuleLevel() {
        ++this.ruleLevel;
    }

    public void decRuleLevel() {
        --this.ruleLevel;
    }

    public PropertyLabelParser(TokenStream input) {
        this(input, 49100, new RecognizerSharedState());
    }

    public PropertyLabelParser(TokenStream input, int port, RecognizerSharedState state) {
        super(input, state);
        DebugEventSocketProxy proxy = new DebugEventSocketProxy((BaseRecognizer)this, port, (TreeAdaptor)this.adaptor);
        this.setDebugListener((DebugEventListener)proxy);
        this.setTokenStream((TokenStream)new DebugTokenStream(input, (DebugEventListener)proxy));
        try {
            proxy.handshake();
        }
        catch (IOException ioe) {
            this.reportError(ioe);
        }
        CommonTreeAdaptor adap = new CommonTreeAdaptor();
        this.setTreeAdaptor((TreeAdaptor)adap);
        proxy.setTreeAdaptor((TreeAdaptor)adap);
    }

    public PropertyLabelParser(TokenStream input, DebugEventListener dbg) {
        super(input, dbg);
        CommonTreeAdaptor adap = new CommonTreeAdaptor();
        this.setTreeAdaptor((TreeAdaptor)adap);
    }

    protected boolean evalPredicate(boolean result, String predicate) {
        this.dbg.semanticPredicate(result, predicate);
        return result;
    }

    public void setTreeAdaptor(TreeAdaptor adaptor) {
        this.adaptor = new DebugTreeAdaptor(this.dbg, adaptor);
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public String[] getTokenNames() {
        return tokenNames;
    }

    public String getGrammarFileName() {
        return "D:\\Workspaces\\Papyrus_Branch_0.7\\org.eclipse.papyrus.parsers_TRUNK\\resources\\grammars\\PropertyLabel.g";
    }

    public PropertyLabelParser(TokenStream lexer, Property property, IErrorReporter reporter) {
        this(lexer);
        this.setProperty(property);
        this.setErrorReporter(reporter);
        this.modifiersUsed = new HashMap<String, Boolean>();
        this.modifiersUsed.put("readOnly", false);
        this.modifiersUsed.put("union", false);
        this.modifiersUsed.put("ordered", false);
        this.modifiersUsed.put("unique", false);
        this.modifiersUsed.put("nonunique", false);
        this.modifiersUsed.put("subsets ", false);
        this.modifiersUsed.put("redefines ", false);
    }

    public boolean isValidation() {
        return this.isValidation;
    }

    public void setValidation(boolean isValidation) {
        this.isValidation = isValidation;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
        this.nearestPackage = property.getNearestPackage();
    }

    private void debug(Object debug) {
    }

    private void error(Object debug) {
    }

    public int getContext() {
        return this.context;
    }

    public void setContext(int context) {
        this.context = context;
    }

    private void applyValues() {
        if (!this.isValidation) {
            this.debug("\nvalues applied :");
            this.debug("+  name: " + this.name);
            this.debug("+  visibility: " + this.visibility);
            this.debug("+  isDerived: " + this.isDerived);
            this.debug("+  type: " + this.type);
            this.debug("+  lower Multiplicity: " + this.lowerMultiplicity);
            this.debug("+  upper Multiplicity: " + this.upperMultiplicity);
            this.debug("+  default Value: " + this.defaultValue);
            this.debug("+  Property modifiers");
            this.debug("+    isReadOnly: " + this.isReadOnly);
            this.debug("+    isUnique: " + this.isUnique);
            this.debug("+    isOrdered: " + this.isOrdered);
            this.debug("+    isDerivedUnion: " + this.isDerivedUnion);
            this.debug("+  SubsettedProperties: " + this.subsettedProperties);
            this.debug("+  RedefinedProperties: " + this.redefinedProperties);
            this.property.setName(this.name);
            this.property.setVisibility(this.visibility);
            this.property.setIsDerived(this.isDerived);
            this.property.setType(this.type);
            this.property.setLower(this.lowerMultiplicity);
            this.property.setUpper(this.upperMultiplicity);
            this.property.setDefault(this.defaultValue);
            this.property.setIsReadOnly(this.isReadOnly);
            this.property.setIsUnique(this.isUnique);
            this.property.setIsOrdered(this.isOrdered);
            this.property.setIsDerivedUnion(this.isDerivedUnion);
            this.property.getSubsettedProperties().clear();
            this.property.getSubsettedProperties().addAll(this.subsettedProperties);
            this.property.getRedefinedProperties().clear();
            this.property.getRedefinedProperties().addAll(this.redefinedProperties);
        }
    }

    private Property findSubsettedPropertyByName(String propertyName, Property property) throws TypeRecognitionException {
        Property subsettedProperty = null;
        for (Property tmpProperty : PropertyUtil.getSubsettablesProperties((Property)property, (boolean)true)) {
            if (!propertyName.equals(tmpProperty.getName())) continue;
            subsettedProperty = tmpProperty;
        }
        if (subsettedProperty == null) {
            throw new TypeRecognitionException("Property " + propertyName + " has not been found or can not be subset", property.getName());
        }
        this.checkProperty(property, subsettedProperty);
        return subsettedProperty;
    }

    private void checkProperty(Property property, Property subsettedProperty) throws RuntimeException {
        int propertyLowerBound = this.lowerMultiplicity;
        int subsettedPropertyLowerBound = subsettedProperty.getLower();
        int propertyUpperBound = this.upperMultiplicity;
        int subsettedPropertyUpperBound = subsettedProperty.getUpper();
        Type propertyType = property.getType();
        Type subsettedPropertyType = subsettedProperty.getType();
        String propertyName = property.getName();
        if (propertyLowerBound < subsettedPropertyLowerBound) {
            throw new MultiplicityException(String.valueOf(propertyName) + " Lower Bound (" + this.lowerMultiplicity + ") can not be lower than subsetted property Lower Bound (" + subsettedPropertyLowerBound + ")");
        }
        if (subsettedPropertyUpperBound != -1 && propertyUpperBound > subsettedPropertyUpperBound) {
            throw new MultiplicityException(String.valueOf(propertyName) + " Upper Bound (" + this.upperMultiplicity + ") can not be greater than subsetted property Upper Bound (" + subsettedPropertyUpperBound + ")");
        }
        if (!propertyType.conformsTo(subsettedPropertyType)) {
            throw new TypeRecognitionException(String.valueOf(propertyName) + " Type (" + propertyType.getName() + ") does not conform to subsetted property type", subsettedPropertyType.getName());
        }
    }

    private Property findRedefinedPropertyByName(String propertyName, Property property) throws TypeRecognitionException {
        Property redefinedProperty = PropertyUtil.findRedefinedPropertyByName((String)propertyName, (Property)property);
        if (redefinedProperty == null) {
            throw new TypeRecognitionException("Property " + propertyName + " has not been found or can not be redefined", property.getName());
        }
        return redefinedProperty;
    }

    public Map<String, Boolean> getModifiersUsed() {
        return this.modifiersUsed;
    }

    public void setModifiersUsed(Map<String, Boolean> modifiersUsed) {
        this.modifiersUsed = modifiersUsed;
    }

    public void setErrorReporter(IErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public IErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public String getErrorMessage(RecognitionException exception, String[] arg1) {
        if (exception instanceof NameException) {
            return "Please enter a correct name for the property";
        }
        return super.getErrorMessage(exception, arg1);
    }

    public void emitErrorMessage(String msg) {
        this.errorReporter.reportError(msg);
    }

    public void recover(IntStream arg0, RecognitionException arg1) {
        throw new RuntimeException("no recover", arg1);
    }

    public final label_return label() throws RecognitionException {
        label_return retval = new label_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token WS1 = null;
        Token WS3 = null;
        Token WS5 = null;
        Token WS7 = null;
        Token COLON8 = null;
        Token WS11 = null;
        Token WS14 = null;
        visibility_return visibility2 = null;
        isDerived_return isDerived4 = null;
        name_return name6 = null;
        property_type_return property_type9 = null;
        fullMultiplicity_return fullMultiplicity10 = null;
        defaultValue_return defaultValue12 = null;
        propertyModifiers_return propertyModifiers13 = null;
        Object WS1_tree = null;
        Object WS3_tree = null;
        Object WS5_tree = null;
        Object WS7_tree = null;
        Object COLON8_tree = null;
        Object WS11_tree = null;
        Object WS14_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "label");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(377, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(378, 3);
                try {
                    this.dbg.enterSubRule(1);
                    block106: while (true) {
                        int alt1 = 2;
                        try {
                            this.dbg.enterDecision(1);
                            int LA1_0 = this.input.LA(1);
                            if (LA1_0 == 4) {
                                alt1 = 1;
                            }
                        }
                        finally {
                            this.dbg.exitDecision(1);
                        }
                        switch (alt1) {
                            case 1: {
                                this.dbg.enterAlt(1);
                                this.dbg.location(378, 4);
                                WS1 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_label46);
                                WS1_tree = this.adaptor.create(WS1);
                                this.adaptor.addChild(root_0, WS1_tree);
                                continue block106;
                            }
                        }
                        break;
                    }
                }
                finally {
                    this.dbg.exitSubRule(1);
                }
                this.dbg.location(379, 3);
                int alt3 = 2;
                try {
                    this.dbg.enterSubRule(3);
                    try {
                        this.dbg.enterDecision(3);
                        int LA3_0 = this.input.LA(1);
                        if (LA3_0 >= 6 && LA3_0 <= 9) {
                            alt3 = 1;
                        }
                    }
                    finally {
                        this.dbg.exitDecision(3);
                    }
                    switch (alt3) {
                        case 1: {
                            this.dbg.enterAlt(1);
                            this.dbg.location(379, 4);
                            this.pushFollow(FOLLOW_visibility_in_label53);
                            visibility2 = this.visibility();
                            --this.state._fsp;
                            this.adaptor.addChild(root_0, visibility2.getTree());
                            this.dbg.location(379, 15);
                            try {
                                this.dbg.enterSubRule(2);
                                block107: while (true) {
                                    int alt2 = 2;
                                    try {
                                        this.dbg.enterDecision(2);
                                        int LA2_0 = this.input.LA(1);
                                        if (LA2_0 == 4) {
                                            alt2 = 1;
                                        }
                                    }
                                    finally {
                                        this.dbg.exitDecision(2);
                                    }
                                    switch (alt2) {
                                        case 1: {
                                            this.dbg.enterAlt(1);
                                            this.dbg.location(379, 16);
                                            WS3 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_label56);
                                            WS3_tree = this.adaptor.create(WS3);
                                            this.adaptor.addChild(root_0, WS3_tree);
                                            continue block107;
                                        }
                                    }
                                    break;
                                }
                            }
                            finally {
                                this.dbg.exitSubRule(2);
                            }
                            this.dbg.location(379, 20);
                            this.context = 1;
                        }
                    }
                }
                finally {
                    this.dbg.exitSubRule(3);
                }
                this.dbg.location(380, 3);
                int alt5 = 2;
                try {
                    this.dbg.enterSubRule(5);
                    try {
                        this.dbg.enterDecision(5);
                        int LA5_0 = this.input.LA(1);
                        if (LA5_0 == 10) {
                            alt5 = 1;
                        }
                    }
                    finally {
                        this.dbg.exitDecision(5);
                    }
                    switch (alt5) {
                        case 1: {
                            this.dbg.enterAlt(1);
                            this.dbg.location(380, 4);
                            this.pushFollow(FOLLOW_isDerived_in_label68);
                            isDerived4 = this.isDerived();
                            --this.state._fsp;
                            this.adaptor.addChild(root_0, isDerived4.getTree());
                            this.dbg.location(380, 14);
                            try {
                                this.dbg.enterSubRule(4);
                                block108: while (true) {
                                    int alt4 = 2;
                                    try {
                                        this.dbg.enterDecision(4);
                                        int LA4_0 = this.input.LA(1);
                                        if (LA4_0 == 4) {
                                            alt4 = 1;
                                        }
                                    }
                                    finally {
                                        this.dbg.exitDecision(4);
                                    }
                                    switch (alt4) {
                                        case 1: {
                                            this.dbg.enterAlt(1);
                                            this.dbg.location(380, 15);
                                            WS5 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_label71);
                                            WS5_tree = this.adaptor.create(WS5);
                                            this.adaptor.addChild(root_0, WS5_tree);
                                            continue block108;
                                        }
                                    }
                                    break;
                                }
                            }
                            finally {
                                this.dbg.exitSubRule(4);
                            }
                            this.dbg.location(380, 20);
                            this.context = 2;
                        }
                    }
                }
                finally {
                    this.dbg.exitSubRule(5);
                }
                this.dbg.location(381, 3);
                this.pushFollow(FOLLOW_name_in_label83);
                name6 = this.name();
                --this.state._fsp;
                this.adaptor.addChild(root_0, name6.getTree());
                this.dbg.location(381, 8);
                try {
                    this.dbg.enterSubRule(6);
                    block109: while (true) {
                        int alt6 = 2;
                        try {
                            this.dbg.enterDecision(6);
                            int LA6_0 = this.input.LA(1);
                            if (LA6_0 == 4) {
                                alt6 = 1;
                            }
                        }
                        finally {
                            this.dbg.exitDecision(6);
                        }
                        switch (alt6) {
                            case 1: {
                                this.dbg.enterAlt(1);
                                this.dbg.location(381, 9);
                                WS7 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_label86);
                                WS7_tree = this.adaptor.create(WS7);
                                this.adaptor.addChild(root_0, WS7_tree);
                                continue block109;
                            }
                        }
                        break;
                    }
                }
                finally {
                    this.dbg.exitSubRule(6);
                }
                this.dbg.location(382, 3);
                COLON8 = (Token)this.match((IntStream)this.input, 5, FOLLOW_COLON_in_label92);
                COLON8_tree = this.adaptor.create(COLON8);
                this.adaptor.addChild(root_0, COLON8_tree);
                this.dbg.location(383, 3);
                this.context = 4;
                this.dbg.location(386, 3);
                this.pushFollow(FOLLOW_property_type_in_label102);
                property_type9 = this.property_type();
                --this.state._fsp;
                this.adaptor.addChild(root_0, property_type9.getTree());
                this.dbg.location(386, 18);
                this.context = 6;
                this.dbg.location(387, 3);
                int alt8 = 2;
                try {
                    this.dbg.enterSubRule(8);
                    try {
                        this.dbg.enterDecision(8);
                        int LA8_0 = this.input.LA(1);
                        if (LA8_0 == 12) {
                            alt8 = 1;
                        }
                    }
                    finally {
                        this.dbg.exitDecision(8);
                    }
                    switch (alt8) {
                        case 1: {
                            this.dbg.enterAlt(1);
                            this.dbg.location(387, 4);
                            this.pushFollow(FOLLOW_fullMultiplicity_in_label110);
                            fullMultiplicity10 = this.fullMultiplicity();
                            --this.state._fsp;
                            this.adaptor.addChild(root_0, fullMultiplicity10.getTree());
                            this.dbg.location(387, 21);
                            this.context = 13;
                            this.dbg.location(387, 64);
                            try {
                                this.dbg.enterSubRule(7);
                                block110: while (true) {
                                    int alt7 = 2;
                                    try {
                                        this.dbg.enterDecision(7);
                                        int LA7_0 = this.input.LA(1);
                                        if (LA7_0 == 4) {
                                            alt7 = 1;
                                        }
                                    }
                                    finally {
                                        this.dbg.exitDecision(7);
                                    }
                                    switch (alt7) {
                                        case 1: {
                                            this.dbg.enterAlt(1);
                                            this.dbg.location(387, 65);
                                            WS11 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_label115);
                                            WS11_tree = this.adaptor.create(WS11);
                                            this.adaptor.addChild(root_0, WS11_tree);
                                            continue block110;
                                        }
                                    }
                                    break;
                                }
                            }
                            finally {
                                this.dbg.exitSubRule(7);
                            }
                        }
                    }
                }
                finally {
                    this.dbg.exitSubRule(8);
                }
                this.dbg.location(388, 3);
                int alt9 = 2;
                try {
                    this.dbg.enterSubRule(9);
                    try {
                        this.dbg.enterDecision(9);
                        int LA9_0 = this.input.LA(1);
                        if (LA9_0 == 17) {
                            alt9 = 1;
                        }
                    }
                    finally {
                        this.dbg.exitDecision(9);
                    }
                    switch (alt9) {
                        case 1: {
                            this.dbg.enterAlt(1);
                            this.dbg.location(388, 4);
                            this.pushFollow(FOLLOW_defaultValue_in_label124);
                            defaultValue12 = this.defaultValue();
                            --this.state._fsp;
                            this.adaptor.addChild(root_0, defaultValue12.getTree());
                            this.dbg.location(388, 17);
                            this.context = 7;
                        }
                    }
                }
                finally {
                    this.dbg.exitSubRule(9);
                }
                this.dbg.location(389, 3);
                int alt11 = 2;
                try {
                    this.dbg.enterSubRule(11);
                    try {
                        this.dbg.enterDecision(11);
                        int LA11_0 = this.input.LA(1);
                        if (LA11_0 == 18) {
                            alt11 = 1;
                        }
                    }
                    finally {
                        this.dbg.exitDecision(11);
                    }
                    switch (alt11) {
                        case 1: {
                            this.dbg.enterAlt(1);
                            this.dbg.location(389, 4);
                            this.pushFollow(FOLLOW_propertyModifiers_in_label134);
                            propertyModifiers13 = this.propertyModifiers();
                            --this.state._fsp;
                            this.adaptor.addChild(root_0, propertyModifiers13.getTree());
                            this.dbg.location(389, 22);
                            this.context = 8;
                            this.dbg.location(389, 65);
                            try {
                                this.dbg.enterSubRule(10);
                                block111: while (true) {
                                    int alt10 = 2;
                                    try {
                                        this.dbg.enterDecision(10);
                                        int LA10_0 = this.input.LA(1);
                                        if (LA10_0 == 4) {
                                            alt10 = 1;
                                        }
                                    }
                                    finally {
                                        this.dbg.exitDecision(10);
                                    }
                                    switch (alt10) {
                                        case 1: {
                                            this.dbg.enterAlt(1);
                                            this.dbg.location(389, 66);
                                            WS14 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_label139);
                                            WS14_tree = this.adaptor.create(WS14);
                                            this.adaptor.addChild(root_0, WS14_tree);
                                            continue block111;
                                        }
                                    }
                                    break;
                                }
                            }
                            finally {
                                this.dbg.exitSubRule(10);
                            }
                        }
                    }
                }
                finally {
                    this.dbg.exitSubRule(11);
                }
                this.dbg.location(390, 3);
                this.applyValues();
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                String index = Integer.toString(mte.index);
                String description = mte.getLocalizedMessage().substring(mte.getLocalizedMessage().indexOf(40), mte.getLocalizedMessage().length());
                String tokenText = mte.token.getText();
                String text = Messages.bind((String)Messages.MismatchedToken, (Object[])new String[]{index, description, tokenText});
                throw new RuntimeException(text);
            }
            catch (NoViableAltException noViableAltException) {
                this.reportError((RecognitionException)((Object)noViableAltException));
                String index = Integer.toString(noViableAltException.index);
                String description = noViableAltException.grammarDecisionDescription.substring(noViableAltException.grammarDecisionDescription.indexOf(40), noViableAltException.grammarDecisionDescription.length());
                String tokenText = noViableAltException.token.getText();
                String text = Messages.bind((String)Messages.NoViableAltException, (Object[])new String[]{index, description, tokenText});
                throw new RuntimeException(text);
            }
            catch (RecognitionException re) {
                this.reportError(re);
                throw re;
            }
            this.dbg.location(393, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "label");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final visibility_return visibility() throws RecognitionException {
        visibility_return retval = new visibility_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token PLUS15 = null;
        Token MINUS16 = null;
        Token SHARP17 = null;
        Token TILDE18 = null;
        Object PLUS15_tree = null;
        Object MINUS16_tree = null;
        Object SHARP17_tree = null;
        Object TILDE18_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "visibility");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(419, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(421, 3);
                int alt12 = 4;
                try {
                    this.dbg.enterSubRule(12);
                    try {
                        this.dbg.enterDecision(12);
                        switch (this.input.LA(1)) {
                            case 6: {
                                alt12 = 1;
                                break;
                            }
                            case 7: {
                                alt12 = 2;
                                break;
                            }
                            case 8: {
                                alt12 = 3;
                                break;
                            }
                            case 9: {
                                alt12 = 4;
                                break;
                            }
                            default: {
                                NoViableAltException nvae = new NoViableAltException("", 12, 0, (IntStream)this.input);
                                this.dbg.recognitionException((RecognitionException)((Object)nvae));
                                throw nvae;
                            }
                        }
                    }
                    finally {
                        this.dbg.exitDecision(12);
                    }
                    switch (alt12) {
                        case 1: {
                            this.dbg.enterAlt(1);
                            this.dbg.location(422, 5);
                            this.dbg.enterAlt(1);
                            this.dbg.location(422, 9);
                            PLUS15 = (Token)this.match((IntStream)this.input, 6, FOLLOW_PLUS_in_visibility203);
                            PLUS15_tree = this.adaptor.create(PLUS15);
                            this.adaptor.addChild(root_0, PLUS15_tree);
                            this.dbg.location(422, 15);
                            this.visibility = VisibilityKind.PUBLIC_LITERAL;
                            break;
                        }
                        case 2: {
                            this.dbg.enterAlt(2);
                            this.dbg.location(423, 5);
                            this.dbg.enterAlt(1);
                            this.dbg.location(423, 9);
                            MINUS16 = (Token)this.match((IntStream)this.input, 7, FOLLOW_MINUS_in_visibility218);
                            MINUS16_tree = this.adaptor.create(MINUS16);
                            this.adaptor.addChild(root_0, MINUS16_tree);
                            this.dbg.location(423, 15);
                            this.visibility = VisibilityKind.PRIVATE_LITERAL;
                            break;
                        }
                        case 3: {
                            this.dbg.enterAlt(3);
                            this.dbg.location(424, 5);
                            this.dbg.enterAlt(1);
                            this.dbg.location(424, 9);
                            SHARP17 = (Token)this.match((IntStream)this.input, 8, FOLLOW_SHARP_in_visibility232);
                            SHARP17_tree = this.adaptor.create(SHARP17);
                            this.adaptor.addChild(root_0, SHARP17_tree);
                            this.dbg.location(424, 15);
                            this.visibility = VisibilityKind.PROTECTED_LITERAL;
                            break;
                        }
                        case 4: {
                            this.dbg.enterAlt(4);
                            this.dbg.location(425, 5);
                            this.dbg.enterAlt(1);
                            this.dbg.location(425, 9);
                            TILDE18 = (Token)this.match((IntStream)this.input, 9, FOLLOW_TILDE_in_visibility246);
                            TILDE18_tree = this.adaptor.create(TILDE18);
                            this.adaptor.addChild(root_0, TILDE18_tree);
                            this.dbg.location(425, 15);
                            this.visibility = VisibilityKind.PACKAGE_LITERAL;
                        }
                    }
                }
                finally {
                    this.dbg.exitSubRule(12);
                }
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                throw new RuntimeException("VisibilityRule");
            }
            catch (NoViableAltException noViableAltException) {
                this.reportError((RecognitionException)((Object)noViableAltException));
                String index = Integer.toString(noViableAltException.index);
                String description = noViableAltException.grammarDecisionDescription.substring(noViableAltException.grammarDecisionDescription.indexOf(40), noViableAltException.grammarDecisionDescription.length());
                String tokenText = noViableAltException.token.getText();
                String text = Messages.bind((String)Messages.NoViableAltException, (Object[])new String[]{index, description, tokenText});
                throw new RuntimeException(text);
            }
            this.dbg.location(427, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "visibility");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final isDerived_return isDerived() throws RecognitionException {
        isDerived_return retval = new isDerived_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token DIV19 = null;
        Object DIV19_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "isDerived");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(445, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(447, 3);
                DIV19 = (Token)this.match((IntStream)this.input, 10, FOLLOW_DIV_in_isDerived287);
                DIV19_tree = this.adaptor.create(DIV19);
                this.adaptor.addChild(root_0, DIV19_tree);
                this.dbg.location(447, 9);
                this.isDerived = true;
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                throw new RuntimeException("IsDerivedRule");
            }
            catch (NoViableAltException noViableAltException) {
                this.reportError((RecognitionException)((Object)noViableAltException));
                String index = Integer.toString(noViableAltException.index);
                String description = noViableAltException.grammarDecisionDescription.substring(noViableAltException.grammarDecisionDescription.indexOf(40), noViableAltException.grammarDecisionDescription.length());
                String tokenText = noViableAltException.token.getText();
                String text = Messages.bind((String)Messages.NoViableAltException, (Object[])new String[]{index, description, tokenText});
                throw new RuntimeException(text);
            }
            this.dbg.location(448, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "isDerived");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final name_return name() throws RecognitionException {
        name_return retval = new name_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token id = null;
        Object id_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "name");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(465, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(467, 5);
                id = (Token)this.match((IntStream)this.input, 11, FOLLOW_IDENTIFIER_in_name326);
                id_tree = this.adaptor.create(id);
                this.adaptor.addChild(root_0, id_tree);
                this.dbg.location(468, 3);
                this.name = id.getText();
                this.context = 3;
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                throw new RuntimeException(Messages.NameMissing);
            }
            catch (NoViableAltException noViableAltException) {
                this.reportError((RecognitionException)((Object)noViableAltException));
                String index = Integer.toString(noViableAltException.index);
                String description = noViableAltException.grammarDecisionDescription.substring(noViableAltException.grammarDecisionDescription.indexOf(40), noViableAltException.grammarDecisionDescription.length());
                String tokenText = noViableAltException.token.getText();
                String text = Messages.bind((String)Messages.NoViableAltException, (Object[])new String[]{index, description, tokenText});
                throw new RuntimeException(text);
            }
            catch (RecognitionException re) {
                this.reportError(re);
                throw re;
            }
            this.dbg.location(472, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "name");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final property_type_return property_type() throws RecognitionException {
        property_type_return retval = new property_type_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token WS20 = null;
        Token string_literal22 = null;
        type_return type21 = null;
        Object WS20_tree = null;
        Object string_literal22_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "property_type");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(492, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(494, 3);
                try {
                    this.dbg.enterSubRule(13);
                    block26: while (true) {
                        int alt13 = 2;
                        try {
                            this.dbg.enterDecision(13);
                            int LA13_0 = this.input.LA(1);
                            if (LA13_0 == 4) {
                                alt13 = 1;
                            }
                        }
                        finally {
                            this.dbg.exitDecision(13);
                        }
                        switch (alt13) {
                            case 1: {
                                this.dbg.enterAlt(1);
                                this.dbg.location(494, 4);
                                WS20 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_property_type375);
                                WS20_tree = this.adaptor.create(WS20);
                                this.adaptor.addChild(root_0, WS20_tree);
                                continue block26;
                            }
                        }
                        break;
                    }
                }
                finally {
                    this.dbg.exitSubRule(13);
                }
                this.dbg.location(495, 3);
                int alt14 = 2;
                try {
                    block34: {
                        this.dbg.enterSubRule(14);
                        try {
                            this.dbg.enterDecision(14);
                            int LA14_0 = this.input.LA(1);
                            if (LA14_0 == 11) {
                                alt14 = 1;
                                break block34;
                            }
                            if (LA14_0 == 55) {
                                alt14 = 2;
                                break block34;
                            }
                            NoViableAltException nvae = new NoViableAltException("", 14, 0, (IntStream)this.input);
                            this.dbg.recognitionException((RecognitionException)((Object)nvae));
                            throw nvae;
                        }
                        finally {
                            this.dbg.exitDecision(14);
                        }
                    }
                    switch (alt14) {
                        case 1: {
                            this.dbg.enterAlt(1);
                            this.dbg.location(495, 5);
                            this.pushFollow(FOLLOW_type_in_property_type383);
                            type21 = this.type();
                            --this.state._fsp;
                            this.adaptor.addChild(root_0, type21.getTree());
                            break;
                        }
                        case 2: {
                            this.dbg.enterAlt(2);
                            this.dbg.location(496, 5);
                            string_literal22 = (Token)this.match((IntStream)this.input, 55, FOLLOW_55_in_property_type391);
                            string_literal22_tree = this.adaptor.create(string_literal22);
                            this.adaptor.addChild(root_0, string_literal22_tree);
                        }
                    }
                }
                finally {
                    this.dbg.exitSubRule(14);
                }
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                throw new RuntimeException("PropertyTypeRule");
            }
            catch (NoViableAltException noViableAltException) {
                this.reportError((RecognitionException)((Object)noViableAltException));
                throw new RuntimeException("Waiting for a valid type or <Undefined>");
            }
            catch (RecognitionException re) {
                this.reportError(re);
                throw re;
            }
            this.dbg.location(498, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "property_type");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final type_return type() throws RecognitionException {
        type_return retval = new type_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token id = null;
        Token id1 = null;
        Token WS23 = null;
        Token WS24 = null;
        Object id_tree = null;
        Object id1_tree = null;
        Object WS23_tree = null;
        Object WS24_tree = null;
        StringBuffer buffer = new StringBuffer();
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "type");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(513, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(518, 5);
                id = (Token)this.match((IntStream)this.input, 11, FOLLOW_IDENTIFIER_in_type451);
                id_tree = this.adaptor.create(id);
                this.adaptor.addChild(root_0, id_tree);
                this.dbg.location(518, 17);
                buffer.append(id.getText());
                this.dbg.location(519, 3);
                try {
                    this.dbg.enterSubRule(15);
                    block33: while (true) {
                        int alt15 = 2;
                        try {
                            this.dbg.enterDecision(15);
                            int LA15_0 = this.input.LA(1);
                            if (LA15_0 == 4) {
                                alt15 = 1;
                            }
                        }
                        finally {
                            this.dbg.exitDecision(15);
                        }
                        switch (alt15) {
                            case 1: {
                                this.dbg.enterAlt(1);
                                this.dbg.location(519, 4);
                                WS23 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_type458);
                                WS23_tree = this.adaptor.create(WS23);
                                this.adaptor.addChild(root_0, WS23_tree);
                                this.dbg.location(519, 7);
                                buffer.append(" ");
                                continue block33;
                            }
                        }
                        break;
                    }
                }
                finally {
                    this.dbg.exitSubRule(15);
                }
                this.dbg.location(521, 3);
                try {
                    this.dbg.enterSubRule(17);
                    block34: while (true) {
                        int alt17 = 2;
                        try {
                            this.dbg.enterDecision(17);
                            int LA17_0 = this.input.LA(1);
                            if (LA17_0 == 11) {
                                alt17 = 1;
                            }
                        }
                        finally {
                            this.dbg.exitDecision(17);
                        }
                        switch (alt17) {
                            case 1: {
                                this.dbg.enterAlt(1);
                                this.dbg.location(522, 8);
                                id1 = (Token)this.match((IntStream)this.input, 11, FOLLOW_IDENTIFIER_in_type475);
                                id1_tree = this.adaptor.create(id1);
                                this.adaptor.addChild(root_0, id1_tree);
                                this.dbg.location(522, 20);
                                buffer.append(id1.getText());
                                this.dbg.location(523, 5);
                                try {
                                    this.dbg.enterSubRule(16);
                                    block35: while (true) {
                                        int alt16 = 2;
                                        try {
                                            this.dbg.enterDecision(16);
                                            int LA16_0 = this.input.LA(1);
                                            if (LA16_0 == 4) {
                                                alt16 = 1;
                                            }
                                        }
                                        finally {
                                            this.dbg.exitDecision(16);
                                        }
                                        switch (alt16) {
                                            case 1: {
                                                this.dbg.enterAlt(1);
                                                this.dbg.location(523, 6);
                                                WS24 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_type484);
                                                WS24_tree = this.adaptor.create(WS24);
                                                this.adaptor.addChild(root_0, WS24_tree);
                                                this.dbg.location(523, 9);
                                                buffer.append(" ");
                                                continue block35;
                                            }
                                        }
                                        break;
                                    }
                                    continue block34;
                                }
                                finally {
                                    this.dbg.exitSubRule(16);
                                    continue block34;
                                }
                            }
                        }
                        break;
                    }
                }
                finally {
                    this.dbg.exitSubRule(17);
                }
                this.dbg.location(526, 3);
                String typeName = buffer.toString().trim();
                Type utilType = PackageUtil.findTypeByName((Package)this.nearestPackage, (String)typeName);
                if (utilType != null) {
                    if (utilType instanceof TemplateableElement) {
                        TemplateableElement template = (TemplateableElement)utilType;
                        if (template.isTemplate()) {
                            throw new UnboundTemplateRecognitionException("Parameters of template " + typeName + " are not bound.", template);
                        }
                        this.type = utilType;
                    } else {
                        this.type = utilType;
                    }
                } else {
                    TemplateableElement template;
                    if (this.property.getOwner() instanceof TemplateableElement && (template = (TemplateableElement)this.property.getOwner()).isTemplate()) {
                        utilType = TemplateSignatureUtil.findTypeByName((TemplateSignature)template.getOwnedTemplateSignature(), (String)typeName);
                    }
                    if (utilType == null) {
                        throw new TypeRecognitionException("Type " + typeName + " not found for property " + this.property.getName(), typeName);
                    }
                    if (utilType instanceof TemplateableElement && ((TemplateableElement)utilType).isTemplate()) {
                        throw new UnboundTemplateRecognitionException("Parameters of template " + typeName + " are not bound.", (TemplateableElement)utilType);
                    }
                    this.type = utilType;
                }
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                throw new RuntimeException("TypeRule");
            }
            catch (RecognitionException re) {
                this.reportError(re);
                throw re;
            }
            this.dbg.location(564, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "type");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final fullMultiplicity_return fullMultiplicity() throws RecognitionException {
        fullMultiplicity_return retval = new fullMultiplicity_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token ra = null;
        Token up = null;
        Token LSQUARE25 = null;
        Token RSQUARE26 = null;
        Object ra_tree = null;
        Object up_tree = null;
        Object LSQUARE25_tree = null;
        Object RSQUARE26_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "fullMultiplicity");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(575, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(577, 3);
                LSQUARE25 = (Token)this.match((IntStream)this.input, 12, FOLLOW_LSQUARE_in_fullMultiplicity537);
                LSQUARE25_tree = this.adaptor.create(LSQUARE25);
                this.adaptor.addChild(root_0, LSQUARE25_tree);
                this.dbg.location(578, 3);
                this.context = 10;
                this.dbg.location(594, 3);
                int alt18 = 2;
                try {
                    block22: {
                        this.dbg.enterSubRule(18);
                        try {
                            this.dbg.enterDecision(18);
                            int LA18_0 = this.input.LA(1);
                            if (LA18_0 == 13) {
                                alt18 = 1;
                                break block22;
                            }
                            if (LA18_0 == 14) {
                                alt18 = 2;
                                break block22;
                            }
                            NoViableAltException nvae = new NoViableAltException("", 18, 0, (IntStream)this.input);
                            this.dbg.recognitionException((RecognitionException)((Object)nvae));
                            throw nvae;
                        }
                        finally {
                            this.dbg.exitDecision(18);
                        }
                    }
                    switch (alt18) {
                        case 1: {
                            this.dbg.enterAlt(1);
                            this.dbg.location(595, 7);
                            ra = (Token)this.match((IntStream)this.input, 13, FOLLOW_RANGE_VALUE_in_fullMultiplicity557);
                            ra_tree = this.adaptor.create(ra);
                            this.adaptor.addChild(root_0, ra_tree);
                            this.dbg.location(595, 20);
                            String value = ra != null ? ra.getText() : null;
                            this.upperMultiplicity = Integer.parseInt(value.substring(0, value.lastIndexOf(44)));
                            this.lowerMultiplicity = Integer.parseInt(value.substring(value.lastIndexOf(44) + 1, value.length()));
                            if (this.lowerMultiplicity > this.upperMultiplicity && this.upperMultiplicity != -1) {
                                throw new MultiplicityException("Lower bound (" + this.lowerMultiplicity + ") is greater than upper bound (" + this.upperMultiplicity + ")");
                            }
                            break;
                        }
                        case 2: {
                            this.dbg.enterAlt(2);
                            this.dbg.location(607, 7);
                            up = (Token)this.match((IntStream)this.input, 14, FOLLOW_INTEGER_in_fullMultiplicity567);
                            up_tree = this.adaptor.create(up);
                            this.adaptor.addChild(root_0, up_tree);
                            this.dbg.location(607, 16);
                            this.lowerMultiplicity = this.upperMultiplicity = Integer.parseInt(up != null ? up.getText() : null);
                        }
                    }
                }
                finally {
                    this.dbg.exitSubRule(18);
                }
                this.dbg.location(612, 3);
                RSQUARE26 = (Token)this.match((IntStream)this.input, 15, FOLLOW_RSQUARE_in_fullMultiplicity577);
                RSQUARE26_tree = this.adaptor.create(RSQUARE26);
                this.adaptor.addChild(root_0, RSQUARE26_tree);
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                throw new RuntimeException("FullMultiplicityRule");
            }
            catch (NoViableAltException noViableAltException) {
                this.reportError((RecognitionException)((Object)noViableAltException));
                String index = Integer.toString(noViableAltException.index);
                String description = noViableAltException.grammarDecisionDescription.substring(noViableAltException.grammarDecisionDescription.indexOf(40), noViableAltException.grammarDecisionDescription.length());
                String tokenText = noViableAltException.token.getText();
                String text = Messages.bind((String)Messages.NoViableAltException, (Object[])new String[]{index, description, tokenText});
                throw new RuntimeException(text);
            }
            catch (RecognitionException re) {
                this.reportError(re);
                throw re;
            }
            this.dbg.location(613, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "fullMultiplicity");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final lowerMultiplicity_return lowerMultiplicity() throws RecognitionException {
        lowerMultiplicity_return retval = new lowerMultiplicity_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token in = null;
        Object in_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "lowerMultiplicity");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(635, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(637, 5);
                in = (Token)this.match((IntStream)this.input, 14, FOLLOW_INTEGER_in_lowerMultiplicity629);
                in_tree = this.adaptor.create(in);
                this.adaptor.addChild(root_0, in_tree);
                this.dbg.location(638, 3);
                this.lowerMultiplicity = Integer.parseInt(in.getText());
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (RecognitionException re) {
                this.reportError(re);
                this.recover((IntStream)this.input, re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            }
            this.dbg.location(641, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "lowerMultiplicity");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final upperMultiplicity_return upperMultiplicity() throws RecognitionException {
        upperMultiplicity_return retval = new upperMultiplicity_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        unlimitedNatural_return um = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "upperMultiplicity");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(643, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(645, 5);
                this.pushFollow(FOLLOW_unlimitedNatural_in_upperMultiplicity650);
                um = this.unlimitedNatural();
                --this.state._fsp;
                this.adaptor.addChild(root_0, um.getTree());
                this.dbg.location(646, 3);
                this.upperMultiplicity = um.value;
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (RecognitionException re) {
                this.reportError(re);
                this.recover((IntStream)this.input, re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            }
            this.dbg.location(649, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "upperMultiplicity");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final unlimitedNatural_return unlimitedNatural() throws RecognitionException {
        unlimitedNatural_return retval = new unlimitedNatural_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token in = null;
        Token STAR27 = null;
        Object in_tree = null;
        Object STAR27_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "unlimitedNatural");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(651, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(653, 3);
                int alt19 = 2;
                try {
                    block19: {
                        this.dbg.enterSubRule(19);
                        try {
                            this.dbg.enterDecision(19);
                            int LA19_0 = this.input.LA(1);
                            if (LA19_0 == 16) {
                                alt19 = 1;
                                break block19;
                            }
                            if (LA19_0 == 14) {
                                alt19 = 2;
                                break block19;
                            }
                            NoViableAltException nvae = new NoViableAltException("", 19, 0, (IntStream)this.input);
                            this.dbg.recognitionException((RecognitionException)((Object)nvae));
                            throw nvae;
                        }
                        finally {
                            this.dbg.exitDecision(19);
                        }
                    }
                    switch (alt19) {
                        case 1: {
                            this.dbg.enterAlt(1);
                            this.dbg.location(653, 5);
                            STAR27 = (Token)this.match((IntStream)this.input, 16, FOLLOW_STAR_in_unlimitedNatural678);
                            STAR27_tree = this.adaptor.create(STAR27);
                            this.adaptor.addChild(root_0, STAR27_tree);
                            this.dbg.location(653, 15);
                            retval.value = -1;
                            break;
                        }
                        case 2: {
                            this.dbg.enterAlt(2);
                            this.dbg.location(654, 7);
                            in = (Token)this.match((IntStream)this.input, 14, FOLLOW_INTEGER_in_unlimitedNatural693);
                            in_tree = this.adaptor.create(in);
                            this.adaptor.addChild(root_0, in_tree);
                            this.dbg.location(654, 19);
                            retval.value = Integer.parseInt(in.getText());
                        }
                    }
                }
                finally {
                    this.dbg.exitSubRule(19);
                }
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (RecognitionException re) {
                this.reportError(re);
                this.recover((IntStream)this.input, re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            }
            this.dbg.location(656, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "unlimitedNatural");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final defaultValue_return defaultValue() throws RecognitionException {
        defaultValue_return retval = new defaultValue_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token EQ28 = null;
        expression_return dv = null;
        Object EQ28_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "defaultValue");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(658, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(660, 3);
                EQ28 = (Token)this.match((IntStream)this.input, 17, FOLLOW_EQ_in_defaultValue719);
                EQ28_tree = this.adaptor.create(EQ28);
                this.adaptor.addChild(root_0, EQ28_tree);
                this.dbg.location(660, 9);
                this.pushFollow(FOLLOW_expression_in_defaultValue725);
                dv = this.expression();
                --this.state._fsp;
                this.adaptor.addChild(root_0, dv.getTree());
                this.dbg.location(661, 3);
                this.defaultValue = dv.value.trim();
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                throw new RuntimeException("DefaultValueRule");
            }
            catch (RecognitionException re) {
                this.reportError(re);
                throw re;
            }
            this.dbg.location(665, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "defaultValue");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final expression_return expression() throws RecognitionException {
        expression_return retval = new expression_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token id = null;
        Object id_tree = null;
        StringBuffer buffer = new StringBuffer();
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "expression");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(676, 1);
            try {
                block23: {
                    this.dbg.enterAlt(1);
                    root_0 = this.adaptor.nil();
                    this.dbg.location(681, 4);
                    int cnt20 = 0;
                    try {
                        this.dbg.enterSubRule(20);
                        while (true) {
                            int alt20 = 2;
                            try {
                                this.dbg.enterDecision(20);
                                int LA20_0 = this.input.LA(1);
                                if (LA20_0 >= 4 && LA20_0 <= 17 || LA20_0 >= 19 && LA20_0 <= 62) {
                                    alt20 = 1;
                                } else if (LA20_0 == -1 || LA20_0 == 18) {
                                    alt20 = 2;
                                }
                            }
                            finally {
                                this.dbg.exitDecision(20);
                            }
                            switch (alt20) {
                                case 1: {
                                    this.dbg.enterAlt(1);
                                    this.dbg.location(685, 10);
                                    id = this.input.LT(1);
                                    if (!(this.input.LA(1) >= 4 && this.input.LA(1) <= 17 || this.input.LA(1) >= 19 && this.input.LA(1) <= 62)) {
                                        MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
                                        this.dbg.recognitionException((RecognitionException)mse);
                                        throw mse;
                                    }
                                    this.input.consume();
                                    this.adaptor.addChild(root_0, this.adaptor.create(id));
                                    this.state.errorRecovery = false;
                                    this.dbg.location(686, 5);
                                    buffer.append(id.getText());
                                    break;
                                }
                                default: {
                                    if (cnt20 >= 1) {
                                        break block23;
                                    }
                                    EarlyExitException eee = new EarlyExitException(20, (IntStream)this.input);
                                    this.dbg.recognitionException((RecognitionException)eee);
                                    throw eee;
                                }
                            }
                            ++cnt20;
                        }
                    }
                    finally {
                        this.dbg.exitSubRule(20);
                    }
                }
                this.dbg.location(690, 3);
                retval.value = buffer.toString();
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (RecognitionException re) {
                this.reportError(re);
                throw re;
            }
            this.dbg.location(693, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "expression");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final propertyModifiers_return propertyModifiers() throws RecognitionException {
        propertyModifiers_return retval = new propertyModifiers_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token LCURLY29 = null;
        Token WS30 = null;
        Token WS32 = null;
        Token COMMA33 = null;
        Token WS34 = null;
        Token WS36 = null;
        Token RCURLY37 = null;
        propertyModifier_return propertyModifier31 = null;
        propertyModifier_return propertyModifier35 = null;
        Object LCURLY29_tree = null;
        Object WS30_tree = null;
        Object WS32_tree = null;
        Object COMMA33_tree = null;
        Object WS34_tree = null;
        Object WS36_tree = null;
        Object RCURLY37_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "propertyModifiers");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(700, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(702, 3);
                LCURLY29 = (Token)this.match((IntStream)this.input, 18, FOLLOW_LCURLY_in_propertyModifiers868);
                LCURLY29_tree = this.adaptor.create(LCURLY29);
                this.adaptor.addChild(root_0, LCURLY29_tree);
                this.dbg.location(702, 10);
                try {
                    this.dbg.enterSubRule(21);
                    block51: while (true) {
                        int alt21 = 2;
                        try {
                            this.dbg.enterDecision(21);
                            int LA21_0 = this.input.LA(1);
                            if (LA21_0 == 4) {
                                alt21 = 1;
                            }
                        }
                        finally {
                            this.dbg.exitDecision(21);
                        }
                        switch (alt21) {
                            case 1: {
                                this.dbg.enterAlt(1);
                                this.dbg.location(702, 11);
                                WS30 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_propertyModifiers871);
                                WS30_tree = this.adaptor.create(WS30);
                                this.adaptor.addChild(root_0, WS30_tree);
                                continue block51;
                            }
                        }
                        break;
                    }
                }
                finally {
                    this.dbg.exitSubRule(21);
                }
                this.dbg.location(703, 3);
                this.context = 9;
                this.dbg.location(704, 3);
                this.pushFollow(FOLLOW_propertyModifier_in_propertyModifiers881);
                propertyModifier31 = this.propertyModifier();
                --this.state._fsp;
                this.adaptor.addChild(root_0, propertyModifier31.getTree());
                this.dbg.location(704, 20);
                try {
                    this.dbg.enterSubRule(22);
                    block52: while (true) {
                        int alt22 = 2;
                        try {
                            this.dbg.enterDecision(22);
                            int LA22_0 = this.input.LA(1);
                            if (LA22_0 == 4) {
                                alt22 = 1;
                            }
                        }
                        finally {
                            this.dbg.exitDecision(22);
                        }
                        switch (alt22) {
                            case 1: {
                                this.dbg.enterAlt(1);
                                this.dbg.location(704, 21);
                                WS32 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_propertyModifiers884);
                                WS32_tree = this.adaptor.create(WS32);
                                this.adaptor.addChild(root_0, WS32_tree);
                                continue block52;
                            }
                        }
                        break;
                    }
                }
                finally {
                    this.dbg.exitSubRule(22);
                }
                this.dbg.location(705, 3);
                try {
                    this.dbg.enterSubRule(25);
                    block53: while (true) {
                        int alt25 = 2;
                        try {
                            this.dbg.enterDecision(25);
                            int LA25_0 = this.input.LA(1);
                            if (LA25_0 == 19) {
                                alt25 = 1;
                            }
                        }
                        finally {
                            this.dbg.exitDecision(25);
                        }
                        switch (alt25) {
                            case 1: {
                                this.dbg.enterAlt(1);
                                this.dbg.location(706, 5);
                                this.context = 9;
                                this.dbg.location(707, 5);
                                COMMA33 = (Token)this.match((IntStream)this.input, 19, FOLLOW_COMMA_in_propertyModifiers903);
                                COMMA33_tree = this.adaptor.create(COMMA33);
                                this.adaptor.addChild(root_0, COMMA33_tree);
                                this.dbg.location(707, 11);
                                try {
                                    this.dbg.enterSubRule(23);
                                    block54: while (true) {
                                        int alt23 = 2;
                                        try {
                                            this.dbg.enterDecision(23);
                                            int LA23_0 = this.input.LA(1);
                                            if (LA23_0 == 4) {
                                                alt23 = 1;
                                            }
                                        }
                                        finally {
                                            this.dbg.exitDecision(23);
                                        }
                                        switch (alt23) {
                                            case 1: {
                                                this.dbg.enterAlt(1);
                                                this.dbg.location(707, 12);
                                                WS34 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_propertyModifiers906);
                                                WS34_tree = this.adaptor.create(WS34);
                                                this.adaptor.addChild(root_0, WS34_tree);
                                                continue block54;
                                            }
                                        }
                                        break;
                                    }
                                }
                                finally {
                                    this.dbg.exitSubRule(23);
                                }
                                this.dbg.location(707, 17);
                                this.pushFollow(FOLLOW_propertyModifier_in_propertyModifiers910);
                                propertyModifier35 = this.propertyModifier();
                                --this.state._fsp;
                                this.adaptor.addChild(root_0, propertyModifier35.getTree());
                                this.dbg.location(707, 34);
                                try {
                                    this.dbg.enterSubRule(24);
                                    block55: while (true) {
                                        int alt24 = 2;
                                        try {
                                            this.dbg.enterDecision(24);
                                            int LA24_0 = this.input.LA(1);
                                            if (LA24_0 == 4) {
                                                alt24 = 1;
                                            }
                                        }
                                        finally {
                                            this.dbg.exitDecision(24);
                                        }
                                        switch (alt24) {
                                            case 1: {
                                                this.dbg.enterAlt(1);
                                                this.dbg.location(707, 35);
                                                WS36 = (Token)this.match((IntStream)this.input, 4, FOLLOW_WS_in_propertyModifiers913);
                                                WS36_tree = this.adaptor.create(WS36);
                                                this.adaptor.addChild(root_0, WS36_tree);
                                                continue block55;
                                            }
                                        }
                                        break;
                                    }
                                    continue block53;
                                }
                                finally {
                                    this.dbg.exitSubRule(24);
                                    continue block53;
                                }
                            }
                        }
                        break;
                    }
                }
                finally {
                    this.dbg.exitSubRule(25);
                }
                this.dbg.location(709, 3);
                RCURLY37 = (Token)this.match((IntStream)this.input, 20, FOLLOW_RCURLY_in_propertyModifiers925);
                RCURLY37_tree = this.adaptor.create(RCURLY37);
                this.adaptor.addChild(root_0, RCURLY37_tree);
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                throw new RuntimeException("DefaultValueRule");
            }
            catch (RecognitionException re) {
                this.reportError(re);
                throw re;
            }
            this.dbg.location(710, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "propertyModifiers");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final propertyModifier_return propertyModifier() throws RecognitionException {
        propertyModifier_return retval = new propertyModifier_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token string_literal38 = null;
        Token string_literal39 = null;
        Token string_literal40 = null;
        Token string_literal41 = null;
        Token string_literal42 = null;
        Token string_literal43 = null;
        subsetsProperty_return subsetsProperty44 = null;
        redefinesProperty_return redefinesProperty45 = null;
        Object string_literal38_tree = null;
        Object string_literal39_tree = null;
        Object string_literal40_tree = null;
        Object string_literal41_tree = null;
        Object string_literal42_tree = null;
        Object string_literal43_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "propertyModifier");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(720, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(722, 3);
                int alt26 = 7;
                try {
                    this.dbg.enterSubRule(26);
                    try {
                        this.dbg.enterDecision(26);
                        switch (this.input.LA(1)) {
                            case 56: {
                                alt26 = 1;
                                break;
                            }
                            case 57: {
                                alt26 = 2;
                                break;
                            }
                            case 58: {
                                alt26 = 3;
                                break;
                            }
                            case 59: {
                                alt26 = 4;
                                break;
                            }
                            case 60: {
                                alt26 = 5;
                                break;
                            }
                            case 61: {
                                alt26 = 6;
                                break;
                            }
                            case 62: {
                                alt26 = 7;
                                break;
                            }
                            default: {
                                NoViableAltException nvae = new NoViableAltException("", 26, 0, (IntStream)this.input);
                                this.dbg.recognitionException((RecognitionException)((Object)nvae));
                                throw nvae;
                            }
                        }
                    }
                    finally {
                        this.dbg.exitDecision(26);
                    }
                    switch (alt26) {
                        case 1: {
                            this.dbg.enterAlt(1);
                            this.dbg.location(723, 5);
                            string_literal38 = (Token)this.match((IntStream)this.input, 56, FOLLOW_56_in_propertyModifier965);
                            string_literal38_tree = this.adaptor.create(string_literal38);
                            this.adaptor.addChild(root_0, string_literal38_tree);
                            this.dbg.location(723, 17);
                            this.isReadOnly = true;
                            this.modifiersUsed.put("readOnly", true);
                            break;
                        }
                        case 2: {
                            this.dbg.enterAlt(2);
                            this.dbg.location(724, 5);
                            string_literal39 = (Token)this.match((IntStream)this.input, 57, FOLLOW_57_in_propertyModifier974);
                            string_literal39_tree = this.adaptor.create(string_literal39);
                            this.adaptor.addChild(root_0, string_literal39_tree);
                            this.dbg.location(724, 15);
                            this.isDerivedUnion = true;
                            this.modifiersUsed.put("union", true);
                            break;
                        }
                        case 3: {
                            this.dbg.enterAlt(3);
                            this.dbg.location(725, 5);
                            string_literal40 = (Token)this.match((IntStream)this.input, 58, FOLLOW_58_in_propertyModifier984);
                            string_literal40_tree = this.adaptor.create(string_literal40);
                            this.adaptor.addChild(root_0, string_literal40_tree);
                            this.dbg.location(725, 15);
                            this.isOrdered = true;
                            this.modifiersUsed.put("ordered", true);
                            break;
                        }
                        case 4: {
                            this.dbg.enterAlt(4);
                            this.dbg.location(726, 5);
                            string_literal41 = (Token)this.match((IntStream)this.input, 59, FOLLOW_59_in_propertyModifier992);
                            string_literal41_tree = this.adaptor.create(string_literal41);
                            this.adaptor.addChild(root_0, string_literal41_tree);
                            this.dbg.location(726, 15);
                            this.isUnique = true;
                            this.modifiersUsed.put("unique", true);
                            this.modifiersUsed.put("nonunique", true);
                            break;
                        }
                        case 5: {
                            this.dbg.enterAlt(5);
                            this.dbg.location(727, 5);
                            string_literal42 = (Token)this.match((IntStream)this.input, 60, FOLLOW_60_in_propertyModifier1001);
                            string_literal42_tree = this.adaptor.create(string_literal42);
                            this.adaptor.addChild(root_0, string_literal42_tree);
                            this.dbg.location(727, 17);
                            this.isUnique = false;
                            this.modifiersUsed.put("unique", true);
                            this.modifiersUsed.put("nonunique", true);
                            break;
                        }
                        case 6: {
                            this.dbg.enterAlt(6);
                            this.dbg.location(728, 5);
                            string_literal43 = (Token)this.match((IntStream)this.input, 61, FOLLOW_61_in_propertyModifier1009);
                            string_literal43_tree = this.adaptor.create(string_literal43);
                            this.adaptor.addChild(root_0, string_literal43_tree);
                            this.dbg.location(728, 15);
                            this.context = 11;
                            this.dbg.location(728, 56);
                            this.pushFollow(FOLLOW_subsetsProperty_in_propertyModifier1013);
                            subsetsProperty44 = this.subsetsProperty();
                            --this.state._fsp;
                            this.adaptor.addChild(root_0, subsetsProperty44.getTree());
                            break;
                        }
                        case 7: {
                            this.dbg.enterAlt(7);
                            this.dbg.location(729, 5);
                            this.pushFollow(FOLLOW_redefinesProperty_in_propertyModifier1021);
                            redefinesProperty45 = this.redefinesProperty();
                            --this.state._fsp;
                            this.adaptor.addChild(root_0, redefinesProperty45.getTree());
                        }
                    }
                }
                finally {
                    this.dbg.exitSubRule(26);
                }
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                throw new RuntimeException("PropertyModifierRule");
            }
            catch (RecognitionException re) {
                this.reportError(re);
                throw re;
            }
            this.dbg.location(731, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "propertyModifier");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final subsetsProperty_return subsetsProperty() throws RecognitionException {
        subsetsProperty_return retval = new subsetsProperty_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token id = null;
        Object id_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "subsetsProperty");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(742, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(744, 5);
                id = (Token)this.match((IntStream)this.input, 11, FOLLOW_IDENTIFIER_in_subsetsProperty1173);
                id_tree = this.adaptor.create(id);
                this.adaptor.addChild(root_0, id_tree);
                this.dbg.location(745, 3);
                String propertyName = id.getText();
                Property tmpProperty = this.findSubsettedPropertyByName(propertyName, this.property);
                this.subsettedProperties.add(tmpProperty);
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                throw new RuntimeException("subsetsPropertyRule");
            }
            catch (RecognitionException re) {
                this.reportError(re);
                throw re;
            }
            this.dbg.location(751, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "subsetsProperty");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public final redefinesProperty_return redefinesProperty() throws RecognitionException {
        redefinesProperty_return retval = new redefinesProperty_return();
        retval.start = this.input.LT(1);
        Object root_0 = null;
        Token id = null;
        Token string_literal46 = null;
        Object id_tree = null;
        Object string_literal46_tree = null;
        try {
            this.dbg.enterRule(this.getGrammarFileName(), "redefinesProperty");
            if (this.getRuleLevel() == 0) {
                this.dbg.commence();
            }
            this.incRuleLevel();
            this.dbg.location(761, 1);
            try {
                this.dbg.enterAlt(1);
                root_0 = this.adaptor.nil();
                this.dbg.location(763, 3);
                this.context = 12;
                this.dbg.location(763, 46);
                string_literal46 = (Token)this.match((IntStream)this.input, 62, FOLLOW_62_in_redefinesProperty1212);
                string_literal46_tree = this.adaptor.create(string_literal46);
                this.adaptor.addChild(root_0, string_literal46_tree);
                this.dbg.location(763, 58);
                this.context = 12;
                this.dbg.location(763, 103);
                id = (Token)this.match((IntStream)this.input, 11, FOLLOW_IDENTIFIER_in_redefinesProperty1218);
                id_tree = this.adaptor.create(id);
                this.adaptor.addChild(root_0, id_tree);
                this.dbg.location(764, 3);
                String propertyName = id.getText();
                Property tmpProperty = this.findRedefinedPropertyByName(propertyName, this.property);
                this.redefinedProperties.add(tmpProperty);
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            catch (MismatchedTokenException mte) {
                this.reportError((RecognitionException)((Object)mte));
                throw new RuntimeException("redefinesPropertyRule");
            }
            catch (RecognitionException re) {
                this.reportError(re);
                throw re;
            }
            this.dbg.location(770, 3);
        }
        finally {
            this.dbg.exitRule(this.getGrammarFileName(), "redefinesProperty");
            this.decRuleLevel();
            if (this.getRuleLevel() == 0) {
                this.dbg.terminate();
            }
        }
        return retval;
    }

    public static class defaultValue_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class expression_return
    extends ParserRuleReturnScope {
        public String value = "";
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class fullMultiplicity_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class isDerived_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class label_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class lowerMultiplicity_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class name_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class propertyModifier_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class propertyModifiers_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class property_type_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class redefinesProperty_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class subsetsProperty_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class type_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class unlimitedNatural_return
    extends ParserRuleReturnScope {
        public int value = 0;
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class upperMultiplicity_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }

    public static class visibility_return
    extends ParserRuleReturnScope {
        Object tree;

        public Object getTree() {
            return this.tree;
        }
    }
}

