/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.modelgenerator;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.parsers.PapyrusParsersPlugin;
import org.eclipse.papyrus.parsers.antlr.ParameterLabelLexer;
import org.eclipse.papyrus.parsers.antlr.ParameterLabelParser;
import org.eclipse.papyrus.parsers.util.SimpleStringErrorReporter;
import org.eclipse.papyrus.parsers.util.TypeRecognitionException;
import org.eclipse.uml2.uml.Parameter;

public class ParameterGenerator {
    private Parameter parameter;
    private SimpleStringErrorReporter reporter;

    public ParameterGenerator(Parameter parameter) {
        this.parameter = parameter;
        this.reporter = new SimpleStringErrorReporter();
    }

    public void parseAndModifyParameter(String label) {
        try {
            ParameterLabelLexer lexer = new ParameterLabelLexer((CharStream)new ANTLRStringStream(label));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            ParameterLabelParser parser = new ParameterLabelParser((TokenStream)tokens, this.parameter, new SimpleStringErrorReporter());
            parser.label();
        }
        catch (RecognitionException e) {
            PapyrusParsersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.classdiagram.parsers", 0, "could not parse the parameter label: " + label, (Throwable)e));
        }
        catch (RuntimeException e) {
            PapyrusParsersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.classdiagram.parsers", 0, "could not parse the parameter label: " + label, (Throwable)e));
        }
    }

    public String parseAndValidateParameter(String label) {
        ParameterLabelLexer lexer = new ParameterLabelLexer((CharStream)new ANTLRStringStream(label));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ParameterLabelParser parser = new ParameterLabelParser((TokenStream)tokens, this.parameter, this.reporter);
        parser.setValidation(true);
        try {
            parser.label();
        }
        catch (MismatchedTokenException e) {
            PapyrusParsersPlugin.logError("context:" + parser.getContext());
        }
        catch (RecognitionException e) {
            this.reporter.setMessage(e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            this.reporter.setMessage(e.getLocalizedMessage());
        }
        return this.reporter.getMessage();
    }

    public String parseUndefinedParameterType(String label) {
        block3: {
            ParameterLabelLexer lexer = new ParameterLabelLexer((CharStream)new ANTLRStringStream(label));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            ParameterLabelParser parser = new ParameterLabelParser((TokenStream)tokens, this.parameter, new SimpleStringErrorReporter());
            parser.setValidation(true);
            try {
                parser.label();
            }
            catch (RecognitionException recognitionException) {
            }
            catch (RuntimeException tse) {
                if (!(tse instanceof TypeRecognitionException)) break block3;
                return ((TypeRecognitionException)tse).getTypeName();
            }
        }
        return null;
    }
}

