/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.modelgenerator;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.parsers.PapyrusParsersPlugin;
import org.eclipse.papyrus.parsers.antlr.PropertyLabelLexer;
import org.eclipse.papyrus.parsers.antlr.PropertyLabelParser;
import org.eclipse.papyrus.parsers.util.SimpleStringErrorReporter;
import org.eclipse.papyrus.parsers.util.TypeRecognitionException;
import org.eclipse.papyrus.parsers.util.UnboundTemplateRecognitionException;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateableElement;

public class PropertyGenerator {
    private Property property;
    private SimpleStringErrorReporter reporter;

    public PropertyGenerator(Property property) {
        this.property = property;
        this.reporter = new SimpleStringErrorReporter();
    }

    public void parseAndModifyProperty(String label) {
        try {
            PropertyLabelLexer lexer = new PropertyLabelLexer((CharStream)new ANTLRStringStream(label));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            PropertyLabelParser parser = new PropertyLabelParser((TokenStream)tokens, this.property, new SimpleStringErrorReporter());
            parser.label();
        }
        catch (RecognitionException e) {
            PapyrusParsersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.classdiagram.parsers", 0, "could not parse the property label: " + label, (Throwable)e));
        }
        catch (RuntimeException e) {
            PapyrusParsersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.classdiagram.parsers", 0, "could not parse the property label: " + label, (Throwable)e));
        }
    }

    public String parseAndValidateProperty(String label) {
        PropertyLabelLexer lexer = new PropertyLabelLexer((CharStream)new ANTLRStringStream(label));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PropertyLabelParser parser = new PropertyLabelParser((TokenStream)tokens, this.property, this.reporter);
        parser.setValidation(true);
        try {
            parser.label();
        }
        catch (MismatchedTokenException mismatchedTokenException) {
        }
        catch (RecognitionException e) {
            this.reporter.setMessage(e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            this.reporter.setMessage(e.getLocalizedMessage());
        }
        return this.reporter.getMessage();
    }

    public String parseUndefinedPropertyType(String label) {
        block3: {
            PropertyLabelLexer lexer = new PropertyLabelLexer((CharStream)new ANTLRStringStream(label));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            PropertyLabelParser parser = new PropertyLabelParser((TokenStream)tokens, this.property, new SimpleStringErrorReporter());
            parser.setValidation(true);
            try {
                parser.label();
            }
            catch (RecognitionException recognitionException) {
            }
            catch (RuntimeException tse) {
                if (!(tse instanceof TypeRecognitionException)) break block3;
                return ((TypeRecognitionException)tse).getTypeName();
            }
        }
        return null;
    }

    public TemplateableElement parseUnboundPropertyType(String label) {
        block3: {
            PropertyLabelLexer lexer = new PropertyLabelLexer((CharStream)new ANTLRStringStream(label));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            PropertyLabelParser parser = new PropertyLabelParser((TokenStream)tokens, this.property, new SimpleStringErrorReporter());
            parser.setValidation(true);
            try {
                parser.label();
            }
            catch (RecognitionException recognitionException) {
            }
            catch (RuntimeException re) {
                if (!(re instanceof UnboundTemplateRecognitionException)) break block3;
                return ((UnboundTemplateRecognitionException)re).getTemplate();
            }
        }
        return null;
    }
}

