/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.parsers.PapyrusParsersPlugin;
import org.eclipse.papyrus.parsers.texteditor.ILabelColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class LabelColorProvider
implements ILabelColorConstants {
    private static LabelColorProvider instance;
    protected Map<String, Color> fColorTable = new HashMap<String, Color>(10);

    private LabelColorProvider() {
    }

    public static LabelColorProvider getDefault() {
        if (instance == null) {
            instance = new LabelColorProvider();
        }
        return instance;
    }

    public static void initializeDefaults(IPreferenceStore aStore) {
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.default", (RGB)ILabelColorConstants.RGB_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.keyword", (RGB)ILabelColorConstants.RGB_KEYWORD);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.string", (RGB)ILabelColorConstants.RGB_STRING);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.symbol", (RGB)ILabelColorConstants.RGB_SYMBOL);
    }

    public Color getColor(String aName) {
        Color color = this.fColorTable.get(aName);
        if (color == null) {
            IPreferenceStore store = PapyrusParsersPlugin.getDefault().getPreferenceStore();
            PreferenceConverter.setValue((IPreferenceStore)store, (String)"org.eclipse.papyrus.classdiagram.parsers.color.symbol", (RGB)ILabelColorConstants.RGB_SYMBOL);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)("org.eclipse.papyrus.classdiagram.parsers.color." + aName));
            if (rgb != null) {
                color = new Color((Device)Display.getCurrent(), rgb);
            } else {
                color = Display.getCurrent().getSystemColor(24);
                PapyrusParsersPlugin.logError("Undefined color '" + aName + "'");
            }
            this.fColorTable.put(aName, color);
        }
        return color;
    }

    public void dispose() {
        Iterator<Color> colors = this.fColorTable.values().iterator();
        while (colors.hasNext()) {
            colors.next().dispose();
        }
    }
}

