/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.collaborationuselabel;

import java.util.Collection;
import java.util.Vector;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.parsers.antlr.CollaborationUseLabelLexer;
import org.eclipse.papyrus.parsers.antlr.CollaborationUseLabelParser;
import org.eclipse.papyrus.parsers.texteditor.LabelCompletionProcessor;
import org.eclipse.papyrus.parsers.texteditor.collaborationuselabel.IContext;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.CollaborationCompletionProposalComputer;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.NameCompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.VisibilityCompletionProposal;
import org.eclipse.papyrus.parsers.util.SimpleStringErrorReporter;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollaborationUseLabelCompletionProcessor
extends LabelCompletionProcessor
implements IContext {
    private CollaborationUse collaborationUse;

    public CollaborationUseLabelCompletionProcessor(CollaborationUse collaborationUse) {
        this.collaborationUse = collaborationUse;
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        CollaborationUseLabelLexer lexer = null;
        CollaborationUseLabelParser parser = null;
        Collection<ICompletionProposal> result = null;
        int selectionRange = 0;
        try {
            String text = viewer.getDocument().get(0, documentOffset);
            lexer = new CollaborationUseLabelLexer((CharStream)new ANTLRStringStream(text));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            parser = new CollaborationUseLabelParser((TokenStream)tokens, this.collaborationUse, new SimpleStringErrorReporter());
            parser.setValidation(true);
            selectionRange = viewer.getSelectedRange().y;
            parser.label();
            result = this.computeCompletions(viewer, parser.getContext(), documentOffset, selectionRange);
        }
        catch (BadLocationException tokens) {
        }
        catch (RuntimeException e) {
            result = this.computeCompletions(viewer, parser.getContext(), documentOffset, selectionRange);
        }
        catch (RecognitionException e) {
            result = this.computeCompletions(viewer, parser.getContext(), documentOffset, selectionRange);
        }
        return result.toArray(new ICompletionProposal[0]);
    }

    @Override
    public Collection<ICompletionProposal> computeCompletions(ITextViewer viewer, int context, int documentOffset, int selectionRange) {
        Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
        String prefix = this.getPrefix(viewer, documentOffset);
        switch (context) {
            case 0: {
                v.addAll(new VisibilityCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                v.addAll(new NameCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 1: {
                v.addAll(new NameCompletionProposal().generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 2: {
                v.addAll(this.createCompletionProposalsWithDifferentName(new String[]{": ", ": <Undefined>"}, new String[]{"CollaborationUse type", "Undefined CollaborationUse type"}, new String[]{": <Collaboration Name>", ": <Undefined>"}, "", documentOffset));
                break;
            }
            case 3: {
                prefix = this.getPrefixForType(viewer, documentOffset);
                CollaborationCompletionProposalComputer computer = new CollaborationCompletionProposalComputer();
                computer.setElement((Element)this.collaborationUse);
                v.addAll(computer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
            case 4: {
                prefix = this.getPrefixForType(viewer, documentOffset);
                CollaborationCompletionProposalComputer computer = new CollaborationCompletionProposalComputer();
                computer.setElement((Element)this.collaborationUse);
                v.addAll(computer.generateCompletionProposals(documentOffset, selectionRange, prefix));
                break;
            }
        }
        return v;
    }
}

