/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.collaborationuselabel;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.papyrus.parsers.texteditor.collaborationuselabel.CollaborationUseLabelColorProvider;
import org.eclipse.papyrus.parsers.texteditor.collaborationuselabel.CollaborationUseLabelCompletionProcessor;
import org.eclipse.papyrus.parsers.texteditor.collaborationuselabel.CollaborationUseLabelScanner;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.CollaborationUse;

public class CollaborationUseLabelSourceViewerConfiguration
extends SourceViewerConfiguration {
    private CollaborationUse collaborationUse;

    public CollaborationUseLabelSourceViewerConfiguration(CollaborationUse collaborationUse) {
        this.setCollaborationUse(collaborationUse);
    }

    public CollaborationUseLabelSourceViewerConfiguration() {
        this(null);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        Color colorString = CollaborationUseLabelColorProvider.getDefault().getColor("string");
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorString)));
        reconciler.setDamager((IPresentationDamager)dr, "_rt_action_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "_rt_action_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)new CollaborationUseLabelScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        CollaborationUseLabelCompletionProcessor processor = new CollaborationUseLabelCompletionProcessor(this.collaborationUse);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        return assistant;
    }

    public CollaborationUse getCollaborationUse() {
        return this.collaborationUse;
    }

    public void setCollaborationUse(CollaborationUse collaborationUse) {
        this.collaborationUse = collaborationUse;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

