/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.completionproposals;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.ICompletionProposalComputer;
import org.eclipse.papyrus.umlutils.PackageUtil;
import org.eclipse.papyrus.umlutils.TypeUtil;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollaborationCompletionProposalComputer
implements ICompletionProposalComputer {
    private Element element;
    private static final String UNDEFINED_TYPE = "<Undefined>";

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    @Override
    public List<ICompletionProposal> generateCompletionProposals(int documentOffset, int selectionRange, String prefix) {
        Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
        CompletionProposal proposal = null;
        if (UNDEFINED_TYPE.startsWith(prefix)) {
            proposal = new CompletionProposal(UNDEFINED_TYPE, documentOffset - prefix.length(), prefix.length() + selectionRange, UNDEFINED_TYPE.length(), null, UNDEFINED_TYPE, null, "Undefined Type");
            v.add((ICompletionProposal)proposal);
        }
        if (this.element != null) {
            Set<Collaboration> types = this.computeAccessibleCollaborationList(this.element);
            for (Collaboration type : types) {
                String name = type.getName();
                if (!name.startsWith(prefix)) continue;
                proposal = new CompletionProposal(name, documentOffset - prefix.length(), prefix.length() + selectionRange, name.length(), null, TypeUtil.getInfoString((Type)type), null, "");
                v.add((ICompletionProposal)proposal);
            }
        }
        return v;
    }

    public Set<Collaboration> computeAccessibleCollaborationList(Element element) {
        LinkedHashSet<Collaboration> list = new LinkedHashSet<Collaboration>();
        list.addAll(PackageUtil.getAccessibleCollaborations((Package)element.getNearestPackage()));
        list.addAll(PackageUtil.getAllCollaborations((Element)element.getNearestPackage()));
        return list;
    }
}

