/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.completionproposals;

import java.util.List;
import java.util.Vector;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.ICompletionProposalComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplicityCompletionProposal
implements ICompletionProposalComputer {
    private static final String EMPTY_MULTIPLICITY = "[]";
    private static final String[] multiplicityStrings = new String[]{"[0..1] ", "[0..*] ", "[1] ", "[1..*] "};
    private static final String[] multiplicityStringsInfo = new String[]{"Multiplicity: [0..1]", "Multiplicity: [0..*]", "Multiplicity: [1]", "Multiplicity: [1..*]"};
    private static final String[] multiplicityStringName = new String[]{"[0..1]", "[0..*]", "[1]", "[1..*]"};

    @Override
    public List<ICompletionProposal> generateCompletionProposals(int documentOffset, int selectionRange, String prefix) {
        Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
        CompletionProposal proposal = null;
        if (EMPTY_MULTIPLICITY.startsWith(prefix)) {
            proposal = new CompletionProposal(EMPTY_MULTIPLICITY, documentOffset - prefix.length(), prefix.length() + selectionRange, 1, null, "[m..n]", null, "Multiplicity");
            v.add((ICompletionProposal)proposal);
        }
        int i = 0;
        while (i < multiplicityStrings.length) {
            if (multiplicityStrings[i].startsWith(prefix)) {
                proposal = new CompletionProposal(multiplicityStrings[i], documentOffset - prefix.length(), prefix.length() + selectionRange, multiplicityStrings[i].length(), null, multiplicityStringName[i], null, multiplicityStringsInfo[i]);
                v.add((ICompletionProposal)proposal);
            }
            ++i;
        }
        return v;
    }
}

