/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.completionproposals;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.ICompletionProposalComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterModifierProposal
implements ICompletionProposalComputer {
    public Map<String, Boolean> modifiersUsed;
    public static final String[] modifiersStrings = new String[]{"ordered", "unique", "nonunique", "exception", "stream"};
    public static final String[] modifiersStringsInfo = new String[]{"Ordered collection property", "No duplicates allowed in the collection", "Duplicates allowed in the collection", "Exception parameter", "Stream parameter"};
    public static final String[] modifiersStringsName = new String[]{"ordered", "unique", "nonunique", "exception", "stream"};

    public Map<String, Boolean> getModifiersUsed() {
        return this.modifiersUsed;
    }

    public void setModifiersUsed(Map<String, Boolean> modifiersUsed) {
        this.modifiersUsed = modifiersUsed;
    }

    @Override
    public List<ICompletionProposal> generateCompletionProposals(int documentOffset, int selectionRange, String prefix) {
        Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
        CompletionProposal proposal = null;
        int i = 0;
        while (i < modifiersStrings.length) {
            if (!this.getModifiersUsed().get(modifiersStrings[i]).booleanValue() && modifiersStrings[i].startsWith(prefix)) {
                proposal = new CompletionProposal(modifiersStrings[i], documentOffset - prefix.length(), prefix.length() + selectionRange, modifiersStrings[i].length(), null, modifiersStringsName[i], null, modifiersStringsInfo[i]);
                v.add((ICompletionProposal)proposal);
            }
            ++i;
        }
        return v;
    }
}

