/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.completionproposals;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.parsers.texteditor.CompletionFilterSourceViewerConfiguration;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.ICompletionProposalComputer;
import org.eclipse.papyrus.umlutils.PackageUtil;
import org.eclipse.papyrus.umlutils.TemplateSignatureUtil;
import org.eclipse.papyrus.umlutils.TypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCompletionProposalComputer
implements ICompletionProposalComputer {
    private static final String UNDEFINED_TYPE = "<Undefined>";
    private Element element;
    private CompletionFilterSourceViewerConfiguration.ICompletionFilter completionFilter;
    private final int propertyType;

    public TypeCompletionProposalComputer() {
        this.completionFilter = new CompletionFilterSourceViewerConfiguration.NullCompletionFilter();
        this.propertyType = -1;
    }

    public TypeCompletionProposalComputer(CompletionFilterSourceViewerConfiguration.ICompletionFilter completionFilter, int propertyType) {
        this.completionFilter = completionFilter == null ? new CompletionFilterSourceViewerConfiguration.NullCompletionFilter() : completionFilter;
        this.propertyType = propertyType;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    @Override
    public List<ICompletionProposal> generateCompletionProposals(int documentOffset, int selectionRange, String prefix) {
        Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
        CompletionProposal proposal = null;
        if (UNDEFINED_TYPE.startsWith(prefix)) {
            proposal = new CompletionProposal(UNDEFINED_TYPE, documentOffset - prefix.length(), prefix.length() + selectionRange, UNDEFINED_TYPE.length(), null, UNDEFINED_TYPE, null, "Undefined Type");
            v.add((ICompletionProposal)proposal);
        }
        if (this.element != null) {
            Set<Type> types = this.computeAccessibleTypeList(this.element);
            for (Type type : types) {
                String name;
                if (this.completionFilter.filter(this.propertyType, (EObject)type) || (name = type.getName()) == null || !name.startsWith(prefix)) continue;
                proposal = new CompletionProposal(name, documentOffset - prefix.length(), prefix.length() + selectionRange, name.length(), null, TypeUtil.getInfoString((Type)type), null, "");
                v.add((ICompletionProposal)proposal);
            }
        }
        return v;
    }

    public Set<Type> computeAccessibleTypeList(Element element) {
        TemplateableElement template;
        LinkedHashSet<Type> list = new LinkedHashSet<Type>();
        list.addAll(PackageUtil.getAccessibleTypes((Package)element.getNearestPackage()));
        if (element.getOwner() != null && element.getOwner() instanceof TemplateableElement && (template = (TemplateableElement)element.getOwner()).isTemplate()) {
            list.addAll(TemplateSignatureUtil.getAccessibleTypes((TemplateSignature)template.getOwnedTemplateSignature()));
        }
        list.addAll(PackageUtil.getAllTypes((Element)element.getNearestPackage()));
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeNameComparator
    implements Comparator<Type> {
        private TypeNameComparator() {
        }

        @Override
        public int compare(Type o1, Type o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

