/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.completionproposals;

import java.util.List;
import java.util.Vector;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.parsers.messages.NFPMessages;
import org.eclipse.papyrus.parsers.texteditor.completionproposals.ICompletionProposalComputer;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSL_Tuple_CompletionProposal
implements ICompletionProposalComputer {
    private static DataType dataType;
    private static String tupleTypeString;
    private static final String[] TVL_Tuple_StringsInfo;
    private static final String[] TVL_Tuple_StringName;

    static {
        TVL_Tuple_StringsInfo = new String[]{NFPMessages.Tuple_StringsInfo};
        TVL_Tuple_StringName = new String[]{NFPMessages.Tuple_StringName};
    }

    public void setDataType(DataType datatype) {
        dataType = datatype;
    }

    public static String computeTVL_Tuple_String() {
        String tupleString = "(";
        tupleTypeString = "(";
        if (dataType != null) {
            if (dataType.getOwnedAttributes().size() > 0) {
                for (Property prop : dataType.getAllAttributes()) {
                    DataType propType = (DataType)prop.getType();
                    tupleString = String.valueOf(tupleString) + prop.getName() + "=";
                    if (prop.getDefault() != null) {
                        tupleString = String.valueOf(tupleString) + prop.getDefault();
                    }
                    tupleString = String.valueOf(tupleString) + " , ";
                    tupleTypeString = String.valueOf(tupleTypeString) + prop.getName() + ": " + propType.getName() + ", ";
                }
            } else {
                tupleString = dataType.getName();
            }
        }
        tupleString = tupleString.substring(0, tupleString.length() - 3);
        tupleString = String.valueOf(tupleString) + ")";
        tupleTypeString = tupleTypeString.substring(0, tupleTypeString.length() - 2);
        tupleTypeString = String.valueOf(tupleTypeString) + ")";
        return tupleString;
    }

    @Override
    public List<ICompletionProposal> generateCompletionProposals(int documentOffset, int selectionRange, String prefix) {
        Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();
        CompletionProposal proposal = null;
        String tupleString = VSL_Tuple_CompletionProposal.computeTVL_Tuple_String();
        if (tupleString.startsWith(prefix)) {
            proposal = new CompletionProposal(tupleString, documentOffset - prefix.length(), prefix.length() + selectionRange, tupleString.length() - 1, null, tupleTypeString, null, TVL_Tuple_StringsInfo[0]);
            v.add((ICompletionProposal)proposal);
        }
        return v;
    }
}

