/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.parameterlabel;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.DefaultDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.parsers.modelgenerator.ParameterGenerator;
import org.eclipse.papyrus.parsers.texteditor.parameterlabel.ParameterLabelSourceViewerConfiguration;
import org.eclipse.papyrus.umlutils.NamedElementUtil;
import org.eclipse.papyrus.umlutils.ParameterUtil;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;

public class ParameterConfigurationForUML
extends DefaultDirectEditorConfiguration {
    private final ParameterLabelSourceViewerConfiguration configuration = new ParameterLabelSourceViewerConfiguration();

    public SourceViewerConfiguration getSourceViewerConfiguration() {
        return this.configuration;
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Parameter) {
            return ParameterUtil.getLabel((Parameter)((Parameter)editedObject));
        }
        return "not a Parameter";
    }

    public Object preEditAction(Object objectToEdit) {
        if (objectToEdit instanceof Parameter) {
            this.configuration.setParameter((Parameter)objectToEdit);
        }
        return super.preEditAction(objectToEdit);
    }

    public Object postEditAction(Object editedObject, String text) {
        if (editedObject instanceof Parameter) {
            ParameterGenerator generator = new ParameterGenerator((Parameter)editedObject);
            generator.parseAndModifyParameter(text);
        }
        return null;
    }

    public IInputValidator getInputValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                if (ParameterConfigurationForUML.this.getObjectToEdit() instanceof Parameter) {
                    ParameterGenerator generator = new ParameterGenerator((Parameter)ParameterConfigurationForUML.this.getObjectToEdit());
                    return generator.parseAndValidateParameter(newText);
                }
                return null;
            }
        };
    }

    public IDirectEditorConfiguration.Selection getTextSelection(String value, Object editedObject) {
        if (editedObject instanceof Parameter) {
            Parameter parameter = (Parameter)editedObject;
            String name = NamedElementUtil.getName((NamedElement)parameter);
            int start = value.indexOf(name);
            int length = name.length();
            return new IDirectEditorConfiguration.Selection(start, length);
        }
        return super.getTextSelection(value, editedObject);
    }
}

