/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.parsers.texteditor.parameterlabel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.parsers.PapyrusParsersPlugin;
import org.eclipse.papyrus.parsers.texteditor.parameterlabel.IParameterLabelColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ParameterLabelColorProvider
implements IParameterLabelColorConstants {
    private static ParameterLabelColorProvider instance;
    protected Map<String, Color> fColorTable = new HashMap<String, Color>(10);

    private ParameterLabelColorProvider() {
    }

    public static ParameterLabelColorProvider getDefault() {
        if (instance == null) {
            instance = new ParameterLabelColorProvider();
        }
        return instance;
    }

    public static void initializeDefaults(IPreferenceStore aStore) {
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.default", (RGB)IParameterLabelColorConstants.RGB_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.keyword", (RGB)IParameterLabelColorConstants.RGB_KEYWORD);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.string", (RGB)IParameterLabelColorConstants.RGB_STRING);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.eclipse.papyrus.classdiagram.parsers.color.symbol", (RGB)IParameterLabelColorConstants.RGB_SYMBOL);
    }

    public Color getColor(String aName) {
        Color color = this.fColorTable.get(aName);
        if (color == null) {
            IPreferenceStore store = PapyrusParsersPlugin.getDefault().getPreferenceStore();
            PreferenceConverter.setValue((IPreferenceStore)store, (String)"org.eclipse.papyrus.classdiagram.parsers.color.symbol", (RGB)IParameterLabelColorConstants.RGB_SYMBOL);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)("org.eclipse.papyrus.classdiagram.parsers.color." + aName));
            if (rgb != null) {
                color = new Color((Device)Display.getCurrent(), rgb);
            } else {
                color = Display.getCurrent().getSystemColor(24);
                PapyrusParsersPlugin.logError("Undefined color '" + aName + "'");
            }
            this.fColorTable.put(aName, color);
        }
        return color;
    }

    public void dispose() {
        Iterator<Color> colors = this.fColorTable.values().iterator();
        while (colors.hasNext()) {
            colors.next().dispose();
        }
    }
}

